/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class LRUCacheTestBase {
    protected Map<String, String> cache;
    protected int maxSize = 10;

    @Before
    public void setUp() {
        this.cache = this.createCache();
    }

    protected abstract Map<String, String> createCache();

    @Test
    public void testPut() {
        int i;
        int numEntries = 20;
        for (i = 0; i < numEntries; ++i) {
            this.cache.put("key" + i, "value" + i);
        }
        Assert.assertEquals((long)this.maxSize, (long)this.cache.size());
        for (i = 10; i < numEntries; ++i) {
            Assert.assertTrue((boolean)this.cache.containsKey("key" + i));
        }
    }

    @Test
    public void testRemove() {
        int i;
        for (i = 0; i < this.maxSize; ++i) {
            this.cache.put("key" + i, "value" + i);
        }
        for (i = 0; i < this.maxSize; ++i) {
            this.cache.remove("key" + i);
        }
        Assert.assertTrue((boolean)this.cache.isEmpty());
    }
}

