/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.impl.RouteImpl;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import org.junit.Test;

public class RouterExtendedParamTest
extends WebTestBase {
    private static Field getAccessibleField(Class<?> clazz, String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        return field;
    }

    @Override
    public void setUp() throws Exception {
        Field reTokenSearch = RouterExtendedParamTest.getAccessibleField(RouteImpl.class, "RE_TOKEN_SEARCH");
        Field reTokenNameSearch = RouterExtendedParamTest.getAccessibleField(RouteImpl.class, "RE_TOKEN_NAME_SEARCH");
        reTokenSearch.set(null, Pattern.compile(":([A-Za-z_$][A-Za-z0-9_$-]*)"));
        reTokenNameSearch.set(null, Pattern.compile("\\(\\?<([A-Za-z_$][A-Za-z0-9_$-]*)>"));
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        Field reTokenSearch = RouterExtendedParamTest.getAccessibleField(RouteImpl.class, "RE_TOKEN_SEARCH");
        Field reTokenNameSearch = RouterExtendedParamTest.getAccessibleField(RouteImpl.class, "RE_TOKEN_NAME_SEARCH");
        reTokenSearch.set(null, Pattern.compile(":([A-Za-z0-9_]+)"));
        reTokenNameSearch.set(null, Pattern.compile("\\(\\?<([A-Za-z0-9_]+)>"));
    }

    @Test
    public void testRouteDashVariable() throws Exception {
        this.router.route("/foo/:my-id").handler(rc -> {
            this.assertEquals("123", rc.pathParam("my-id"));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/foo/123", 200, "OK");
    }

    @Test
    public void testRouteDashVariableNOK() throws Exception {
        this.router.route("/flights/:from-:to").handler(rc -> {
            this.assertNull(rc.pathParam("from"));
            this.assertNotNull(rc.pathParam("from-"));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/flights/LAX-SFO", 200, "OK");
    }
}

