/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CSRFHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.AfterClass;
import org.junit.Test;

public class CSRFHandlerTest
extends WebTestBase {
    String rawCookie;
    String tmpCookie;

    @AfterClass
    public static void oneTimeTearDown() throws IOException {
        CSRFHandlerTest.cleanupFileUploadDir();
    }

    @Test
    public void testGetCookie() throws Exception {
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.get().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            this.assertEquals("XSRF-TOKEN", ((String)cookies.get(0)).substring(0, ((String)cookies.get(0)).indexOf(61)));
        }, 200, "OK", null);
    }

    @Test
    public void testPostWithoutHeader() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.router.route().handler((Handler)BodyHandler.create()).handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.router.errorHandler(403, rc -> latch.countDown());
        this.testRequest(HttpMethod.POST, "/", null, null, 403, "Forbidden", null);
        latch.await();
    }

    @Test
    public void testPostWithHeader() throws Exception {
        this.router.route().handler((Handler)StaticHandler.create());
        this.router.route("/xsrf").handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route("/xsrf").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/xsrf", null, resp -> {
            String cookie;
            List cookies = resp.headers().getAll("set-cookie");
            this.rawCookie = cookie = (String)cookies.get(0);
            this.tmpCookie = cookie.substring(cookie.indexOf(61) + 1, cookie.indexOf(59));
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/xsrf", req -> {
            req.putHeader("X-XSRF-TOKEN", this.tmpCookie);
            req.putHeader("Cookie", this.rawCookie);
        }, null, 200, "OK", null);
    }

    @Test
    public void testPostWithExpiredCookie() throws Exception {
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra").setTimeout(1L));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.putHeader("X-XSRF-TOKEN", "4CYp9vQsr2VSQEsi/oVsMu35Ho9TlR0EovcYovlbiBw=.1437037602082.41jwU0FPl/n7ZNZAZEA07GyIUnpKSTKQ8Eju7Nicb34="), null, 403, "Forbidden", null);
    }

    @Test
    public void testPostWithFormAttribute() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String cookie;
            List cookies = resp.headers().getAll("set-cookie");
            this.rawCookie = cookie = (String)cookies.get(0);
            this.tmpCookie = cookie.substring(cookie.indexOf(61) + 1, cookie.indexOf(59));
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + "X-XSRF-TOKEN" + "\"\r\n\r\n" + this.tmpCookie + "\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.putHeader("Cookie", this.rawCookie);
            req.write((Object)buffer);
        }, null, 200, "OK", null);
    }

    @Test
    public void testPostWithFormAttributeWithoutCookies() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> {
            String token = (String)rc.get("X-XSRF-TOKEN");
            if (token != null) {
                rc.response().end(token);
            } else {
                rc.response().end();
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            resp.bodyHandler(buffer -> {
                this.tmpCookie = buffer.toString();
                latch.countDown();
            });
            List cookies = resp.headers().getAll("set-cookie");
            this.assertTrue(cookies.size() > 0);
        }, 200, "OK", null);
        latch.await();
        this.testRequest(HttpMethod.POST, "/", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + "X-XSRF-TOKEN" + "\"\r\n\r\n" + this.tmpCookie + "\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.write((Object)buffer);
        }, null, 403, "Forbidden", null);
    }

    @Test
    public void testPostWithCustomResponseBody() throws Exception {
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra").setTimeout(1L));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.putHeader("X-XSRF-TOKEN", "4CYp9vQsr2VSQEsi/oVsMu35Ho9TlR0EovcYovlbiBw=.1437037602082.41jwU0FPl/n7ZNZAZEA07GyIUnpKSTKQ8Eju7Nicb34="), null, 403, "Forbidden", "Forbidden");
    }

    @Test
    public void testGetCookieWithSession() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)SessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.get().handler(rc -> rc.response().end());
        AtomicReference sessionID = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(2L, cookies.size());
            for (String cookie : cookies) {
                if (!cookie.startsWith("vertx-web.session=")) continue;
                sessionID.set(cookie);
            }
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)sessionID.get()), resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        }, 200, "OK", null);
    }

    @Test
    public void testGetCookieWithSessionReplay() throws Exception {
        AtomicReference cookieJar = new AtomicReference();
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(2L, cookies.size());
            String encodedCookie = "";
            for (String cookie : cookies) {
                encodedCookie = encodedCookie + cookie.substring(0, cookie.indexOf(59));
                encodedCookie = encodedCookie + "; ";
                if (!cookie.startsWith("XSRF-TOKEN")) continue;
                this.tmpCookie = cookie.substring(cookie.indexOf(61) + 1, cookie.indexOf(59));
            }
            cookieJar.set(encodedCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", (String)cookieJar.get());
            req.putHeader("X-XSRF-TOKEN", this.tmpCookie);
        }, res -> {
            List cookies = res.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", (String)cookieJar.get());
            req.putHeader("X-XSRF-TOKEN", this.tmpCookie);
        }, res -> {}, 403, "Forbidden", null);
    }

    @Test
    public void testGetCookieWithSessionMultipleGetSameToken() throws Exception {
        AtomicReference cookieJar = new AtomicReference();
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(2L, cookies.size());
            String encodedCookie = "";
            for (String cookie : cookies) {
                encodedCookie = encodedCookie + cookie.substring(0, cookie.indexOf(59));
                encodedCookie = encodedCookie + "; ";
                if (!cookie.startsWith("XSRF-TOKEN")) continue;
                this.tmpCookie = cookie.substring(cookie.indexOf(61) + 1, cookie.indexOf(59));
            }
            cookieJar.set(encodedCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)cookieJar.get()), res -> {
            List cookies = res.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", (String)cookieJar.get());
            req.putHeader("X-XSRF-TOKEN", this.tmpCookie);
        }, null, 200, "OK", null);
    }

    @Test
    public void testPostWithHeaderAndOrigin() throws Exception {
        this.router.route().handler((Handler)StaticHandler.create());
        this.router.route("/xsrf").handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra").setOrigin("http://myserver.com"));
        this.router.route("/xsrf").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/xsrf", req -> req.putHeader("Origin", "http://myserver.com"), resp -> {
            String cookie;
            List cookies = resp.headers().getAll("set-cookie");
            this.rawCookie = cookie = (String)cookies.get(0);
            this.tmpCookie = cookie.substring(cookie.indexOf(61) + 1, cookie.indexOf(59));
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/xsrf", req -> {
            req.putHeader("Origin", "http://myserver.com");
            req.putHeader("X-XSRF-TOKEN", this.tmpCookie);
            req.putHeader("Cookie", this.rawCookie);
        }, null, 200, "OK", null);
    }

    @Test
    public void testPostWithHeaderAndWrongOrigin() throws Exception {
        this.router.route().handler((Handler)StaticHandler.create());
        this.router.route("/xsrf").handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra").setOrigin("http://myserver.com"));
        this.router.route("/xsrf").handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/xsrf", req -> req.putHeader("Origin", "https://myserver.com"), null, 403, "Forbidden", null);
        this.testRequest(HttpMethod.GET, "/xsrf", req -> req.putHeader("Origin", "http://myserver.com/"), null, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/xsrf", req -> req.putHeader("Origin", "http://myserver.com:80"), null, 200, "OK", null);
    }

    @Test
    public void testPostAfterPost() throws Exception {
        AtomicReference cookieJar = new AtomicReference();
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(2L, cookies.size());
            String encodedCookie = "";
            for (String cookie : cookies) {
                encodedCookie = encodedCookie + cookie.substring(0, cookie.indexOf(59));
                encodedCookie = encodedCookie + "; ";
                if (!cookie.startsWith("XSRF-TOKEN")) continue;
                this.tmpCookie = cookie.substring(cookie.indexOf(61) + 1, cookie.indexOf(59));
            }
            cookieJar.set(encodedCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", (String)cookieJar.get());
            req.putHeader("X-XSRF-TOKEN", this.tmpCookie);
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            String encodedCookie = "";
            for (String cookie : ((String)cookieJar.get()).split(";")) {
                if ("".equals(cookie = cookie.trim())) continue;
                if (cookie.startsWith("XSRF-TOKEN")) {
                    this.tmpCookie = ((String)cookies.get(0)).substring(((String)cookies.get(0)).indexOf(61) + 1, ((String)cookies.get(0)).indexOf(59));
                    encodedCookie = encodedCookie + "XSRF-TOKEN=" + this.tmpCookie;
                } else {
                    encodedCookie = encodedCookie + cookie;
                }
                encodedCookie = encodedCookie + "; ";
            }
            this.assertFalse(((String)cookieJar.get()).equals(encodedCookie));
            cookieJar.set(encodedCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", (String)cookieJar.get());
            req.putHeader("X-XSRF-TOKEN", this.tmpCookie);
        }, null, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", (String)cookieJar.get());
            req.putHeader("X-XSRF-TOKEN", this.tmpCookie);
        }, null, 403, "Forbidden", null);
    }

    @Test
    public void testPostAfterPostNoState() throws Exception {
        AtomicReference cookieJar = new AtomicReference();
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            String encodedCookie = ((String)cookies.get(0)).substring(0, ((String)cookies.get(0)).indexOf(59));
            this.tmpCookie = ((String)cookies.get(0)).substring(((String)cookies.get(0)).indexOf(61) + 1, ((String)cookies.get(0)).indexOf(59));
            cookieJar.set(encodedCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", (String)cookieJar.get());
            req.putHeader("X-XSRF-TOKEN", this.tmpCookie);
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            String encodedCookie = "";
            for (String cookie : ((String)cookieJar.get()).split(";")) {
                if ("".equals(cookie = cookie.trim())) continue;
                if (cookie.startsWith("XSRF-TOKEN")) {
                    this.tmpCookie = ((String)cookies.get(0)).substring(((String)cookies.get(0)).indexOf(61) + 1, ((String)cookies.get(0)).indexOf(59));
                    encodedCookie = encodedCookie + "XSRF-TOKEN=" + this.tmpCookie;
                } else {
                    encodedCookie = encodedCookie + cookie;
                }
                encodedCookie = encodedCookie + "; ";
            }
            this.assertFalse(((String)cookieJar.get()).equals(encodedCookie));
            cookieJar.set(encodedCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            req.putHeader("cookie", (String)cookieJar.get());
            req.putHeader("X-XSRF-TOKEN", this.tmpCookie);
        }, null, 200, "OK", null);
    }

    @Test
    public void testMultipleGetWithSessionSameToken() throws Exception {
        AtomicReference cookieJar = new AtomicReference();
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)CSRFHandler.create((Vertx)this.vertx, (String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(2L, cookies.size());
            String encodedCookie = "";
            for (String cookie : cookies) {
                encodedCookie = encodedCookie + cookie.substring(0, cookie.indexOf(59));
                encodedCookie = encodedCookie + "; ";
                if (!cookie.startsWith("XSRF-TOKEN")) continue;
                this.tmpCookie = cookie.substring(cookie.indexOf(61) + 1, cookie.indexOf(59));
            }
            cookieJar.set(encodedCookie);
        }, 200, "OK", null);
        for (int i = 0; i < 5; ++i) {
            this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)cookieJar.get()), resp -> {
                List cookies = resp.headers().getAll("set-cookie");
                this.assertEquals(0L, cookies.size());
            }, 200, "OK", null);
        }
    }
}

