/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.junit.Test;

public class CookielessSessionHandlerTestBase
extends WebTestBase {
    private SessionStore store;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.store = LocalSessionStore.create((Vertx)this.vertx);
    }

    @Test
    public void testSessionCreation() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieless(true));
        this.router.route().handler(rc -> rc.response().putHeader("X-Session-Id", "(" + rc.session().value() + ")").end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String sessionId = resp.headers().get("X-Session-Id");
            this.assertTrue(sessionId.startsWith("("));
            this.assertTrue(sessionId.endsWith(")"));
        }, 200, "OK", null);
    }

    @Test
    public void testSession() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieless(true));
        AtomicReference rid = new AtomicReference();
        AtomicInteger requestCount = new AtomicInteger();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertNotNull(sess.id());
            switch (requestCount.get()) {
                case 0: {
                    rid.set(sess.id());
                    sess.put("foo", (Object)"bar");
                    break;
                }
                case 1: {
                    this.assertEquals(rid.get(), sess.id());
                    this.assertEquals("bar", sess.get("foo"));
                    sess.put("eek", (Object)"wibble");
                    break;
                }
                case 2: {
                    this.assertEquals(rid.get(), sess.id());
                    this.assertEquals("bar", sess.get("foo"));
                    this.assertEquals("wibble", sess.get("eek"));
                }
            }
            requestCount.incrementAndGet();
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        Thread.sleep(1000L);
        this.testRequest(HttpMethod.GET, "/(" + (String)rid.get() + ")", 200, "OK");
        Thread.sleep(1000L);
        this.testRequest(HttpMethod.GET, "/(" + (String)rid.get() + ")", 200, "OK");
    }

    @Test
    public void testSessionExpires() throws Exception {
        long timeout = 1000L;
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setSessionTimeout(timeout).setCookieless(true));
        AtomicReference rid = new AtomicReference();
        AtomicInteger requestCount = new AtomicInteger();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertTrue(System.currentTimeMillis() - sess.lastAccessed() < 500L);
            this.assertNotNull(sess.id());
            switch (requestCount.get()) {
                case 0: {
                    sess.put("foo", (Object)"bar");
                    break;
                }
                case 1: {
                    this.assertFalse(((String)rid.get()).equals(sess.id()));
                    this.assertNull(sess.get("foo"));
                }
            }
            rid.set(sess.id());
            requestCount.incrementAndGet();
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        Thread.sleep(2L * (1000L + timeout));
        this.testRequest(HttpMethod.GET, "/(" + (String)rid.get() + ")", 200, "OK");
        CookielessSessionHandlerTestBase.waitUntil(() -> this.testSessionBlocking((String)rid.get(), Objects::nonNull));
        Thread.sleep(2L * (1000L + timeout));
        CookielessSessionHandlerTestBase.waitUntil(() -> this.testSessionBlocking((String)rid.get(), Objects::isNull));
    }

    private boolean testSessionBlocking(String sessionId, Function<Session, Boolean> test) {
        CompletableFuture cf = new CompletableFuture();
        this.store.get(sessionId, ar -> {
            if (ar.succeeded()) {
                cf.complete(test.apply((Session)ar.result()));
            } else {
                cf.completeExceptionally(ar.cause());
            }
        });
        try {
            return (Boolean)cf.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testDestroySession() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieless(true));
        AtomicReference rid = new AtomicReference();
        AtomicInteger requestCount = new AtomicInteger();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertTrue(System.currentTimeMillis() - sess.lastAccessed() < 500L);
            this.assertNotNull(sess.id());
            switch (requestCount.get()) {
                case 0: {
                    rid.set(sess.id());
                    sess.put("foo", (Object)"bar");
                    sess.destroy();
                    break;
                }
                case 1: {
                    this.assertFalse(((String)rid.get()).equals(sess.id()));
                    this.assertNull(sess.get("foo"));
                    rid.set(sess.id());
                    sess.destroy();
                }
            }
            requestCount.incrementAndGet();
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        Thread.sleep(500L);
        CountDownLatch latch1 = new CountDownLatch(1);
        this.store.get((String)rid.get(), this.onSuccess(res -> {
            this.assertNull(res);
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
    }

    @Test
    public void testLastAccessed1() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieless(true));
        AtomicReference rid = new AtomicReference();
        long start = System.currentTimeMillis();
        this.router.route().handler(rc -> {
            rid.set(rc.session());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        this.assertTrue(((Session)rid.get()).lastAccessed() - start < 500L);
        start = System.currentTimeMillis();
        Thread.sleep(1000L);
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        this.assertTrue(((Session)rid.get()).lastAccessed() - start >= 1000L);
    }

    @Test
    public void testLastAccessed2() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieless(true));
        AtomicReference rid = new AtomicReference();
        this.router.route().handler(rc -> {
            rid.set(rc.session());
            rc.session().put("foo", (Object)"bar");
            this.vertx.setTimer(1000L, tid -> rc.response().end());
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        this.assertTrue(((Session)rid.get()).lastAccessed() - System.currentTimeMillis() < 500L);
    }

    @Test
    public void testIssue172_setnull() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieless(true));
        AtomicReference rid = new AtomicReference();
        this.router.route().handler(rc -> {
            rid.set(rc.session());
            rc.session().put("foo", null);
            this.vertx.setTimer(1000L, tid -> rc.response().end());
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }
}

