/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.WebSocketInternal;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import io.vertx.ext.auth.properties.PropertyFileAuthorization;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.impl.JsonCodec;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.test.core.TestUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EventbusBridgeTest
extends WebTestBase {
    protected SockJSHandler sockJSHandler;
    protected SockJSBridgeOptions defaultOptions = new SockJSBridgeOptions();
    protected SockJSBridgeOptions allAccessOptions = new SockJSBridgeOptions().addInboundPermitted(new PermittedOptions()).addOutboundPermitted(new PermittedOptions());
    protected String websocketURI = "/eventbus/websocket";
    protected String addr = "someaddress";
    private Transport transport;

    @Parameterized.Parameters(name="{index}: transport = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({Transport.RAW_WS}, {Transport.WS});
    }

    public EventbusBridgeTest(Transport transport) {
        this.transport = transport;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sockJSHandler = SockJSHandler.create((Vertx)this.vertx);
        this.router.route("/eventbus/*").handler((Handler)this.sockJSHandler);
    }

    @Test
    public void testHookCreateSocket() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SOCKET_CREATED) {
                this.assertNotNull(be.socket());
                this.assertNull(be.getRawMessage());
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testSend("foobar");
        this.await();
    }

    @Test
    public void testHookCreateSocketRejected() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SOCKET_CREATED) {
                be.complete((Object)false);
                latch.countDown();
            } else {
                be.complete((Object)true);
            }
        });
        BridgeClient client = new BridgeClient();
        client.connect(this.websocketURI).compose(v -> client.send(this.addr, "foobar")).onComplete(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
    }

    @Test
    public void testHookSocketClosed() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SOCKET_CLOSED) {
                this.assertNotNull(be.socket());
                this.assertNull(be.getRawMessage());
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        BridgeClient client = new BridgeClient();
        client.connect(this.websocketURI).onComplete(this.onSuccess(v -> client.close()));
        this.await();
    }

    @Test
    public void testHookSocketClosedAbruptly() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SOCKET_CLOSED) {
                this.assertNotNull(be.socket());
                this.assertNull(be.getRawMessage());
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        BridgeClient client = new BridgeClient();
        client.connect(this.websocketURI).onComplete(this.onSuccess(v -> ((TransportClient)client.transportClient.result()).abruptClose()));
        this.await();
    }

    @Test
    public void testHookSend() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SEND) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.assertEquals("foobar", raw.getString("body"));
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testSend("foobar");
        this.await();
    }

    @Test
    public void testHookSendHeaders() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SEND) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.assertEquals("foobar", raw.getString("body"));
                raw.put("headers", (Object)new JsonObject().put("hdr1", (Object)"val1").put("hdr2", (Object)"val2"));
                be.setRawMessage(raw);
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testSend(this.addr, "foobar", true);
        this.await();
    }

    @Test
    public void testHookSendRejected() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SEND) {
                be.complete((Object)false);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("body", (Object)"foobar"), "rejected");
        this.await();
    }

    @Test
    public void testHookSendMissingAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SEND) {
                be.getRawMessage().remove("address");
                this.testComplete();
            }
            be.complete((Object)true);
        });
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("body", (Object)"foobar"), "missing_address");
        this.await();
    }

    @Test
    public void testHookPublish() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.PUBLISH) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.assertEquals("foobar", raw.getString("body"));
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testPublish("foobar");
        this.await();
    }

    @Test
    public void testHookPublishHeaders() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.PUBLISH) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.assertEquals("foobar", raw.getString("body"));
                raw.put("headers", (Object)new JsonObject().put("hdr1", (Object)"val1").put("hdr2", (Object)"val2"));
                be.setRawMessage(raw);
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testPublish(this.addr, "foobar", true);
        this.await();
    }

    @Test
    public void testHookPubRejected() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.PUBLISH) {
                be.complete((Object)false);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testError(new JsonObject().put("type", (Object)"publish").put("address", (Object)this.addr).put("body", (Object)"foobar"), "rejected");
        this.await();
    }

    @Test
    public void testHookPublishMissingAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.PUBLISH) {
                be.getRawMessage().remove("address");
                this.testComplete();
            }
            be.complete((Object)true);
        });
        this.testError(new JsonObject().put("type", (Object)"publish").put("address", (Object)this.addr).put("body", (Object)"foobar"), "missing_address");
        this.await();
    }

    @Test
    public void testHookRegister() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.REGISTER) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testReceive("foobar");
        this.await();
    }

    @Test
    public void testHookRegisterRejected() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.REGISTER) {
                be.complete((Object)false);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testError(new JsonObject().put("type", (Object)"register").put("address", (Object)this.addr), "rejected");
        this.await();
    }

    @Test
    public void testHookRegisterMissingAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.REGISTER) {
                be.getRawMessage().remove("address");
                this.testComplete();
            }
            be.complete((Object)true);
        });
        this.testError(new JsonObject().put("type", (Object)"register").put("address", (Object)this.addr).put("body", (Object)"foobar"), "missing_address");
        this.await();
    }

    @Test
    public void testHookRegistered() throws Exception {
        CountDownLatch registerLatch = new CountDownLatch(1);
        CountDownLatch registeredLatch = new CountDownLatch(1);
        CountDownLatch requestLatch = new CountDownLatch(1);
        String payload = "hello slinkydeveloper!";
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.REGISTER) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                registerLatch.countDown();
            } else if (be.type() == BridgeEventType.REGISTERED) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.vertx.eventBus().send(this.addr, (Object)"hello slinkydeveloper!");
                registeredLatch.countDown();
            }
            be.complete((Object)true);
        });
        BridgeClient client = new BridgeClient();
        client.handler((address, body) -> {
            this.assertEquals(this.addr, address);
            this.assertEquals("hello slinkydeveloper!", body);
            client.close().onComplete(v2 -> requestLatch.countDown());
        });
        client.connect(this.websocketURI).compose(v -> client.register(this.addr)).onComplete(this.onSuccess(v -> {}));
        this.awaitLatch(registerLatch);
        this.awaitLatch(registeredLatch);
        this.awaitLatch(requestLatch);
    }

    @Test
    public void testHookReceive() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.RECEIVE) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.assertEquals("foobar", raw.getString("body"));
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testReceive("foobar");
        this.await();
    }

    @Test
    public void testHookReceiveRejected() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.RECEIVE) {
                be.complete((Object)false);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testReceiveFail(this.addr, "foobar");
        this.await();
    }

    @Test
    public void testHookUnregister() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.UNREGISTER) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testUnregister(this.addr);
        this.await();
    }

    @Test
    public void testHookUnregisterRejected() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.UNREGISTER) {
                be.complete((Object)false);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testError(new JsonObject().put("type", (Object)"unregister").put("address", (Object)this.addr), "rejected");
        this.await();
    }

    @Test
    public void testHookUnregisterMissingAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.UNREGISTER) {
                be.getRawMessage().remove("address");
                this.testComplete();
            }
            be.complete((Object)true);
        });
        this.testError(new JsonObject().put("type", (Object)"unregister").put("address", (Object)this.addr).put("body", (Object)"foobar"), "missing_address");
        this.await();
    }

    @Test
    public void testSendStringAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend("foobar");
    }

    @Test
    public void testSendJsonObjectAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend(new JsonObject().put("foo", (Object)"bar").put("blah", (Object)123));
    }

    @Test
    public void testSendJsonArrayAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend(new JsonArray().add((Object)"foo").add((Object)1456));
    }

    @Test
    public void testSendNumberAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend(13456);
    }

    @Test
    public void testSendBooleanTrueAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend(true);
    }

    @Test
    public void testSendBooleanFalseAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend(false);
    }

    @Test
    public void testPublishStringAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish("foobar");
    }

    @Test
    public void testPublishJsonObjectAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish(new JsonObject().put("foo", (Object)"bar").put("blah", (Object)123));
    }

    @Test
    public void testPublishJsonArrayAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish(new JsonArray().add((Object)"foo").add((Object)1456));
    }

    @Test
    public void testPublishNumberAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish(13456);
    }

    @Test
    public void testPublishBooleanTrueAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish(true);
    }

    @Test
    public void testPublishBooleanFalseAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish(false);
    }

    @Test
    public void testReceiveStringAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive("foobar");
    }

    @Test
    public void testReceiveJsonObjectAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive(new JsonObject().put("foo", (Object)"bar").put("blah", (Object)123));
    }

    @Test
    public void testReceiveJsonArrayAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive(new JsonArray().add((Object)"foo").add((Object)1456));
    }

    @Test
    public void testReceiveNumberAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive(13456);
    }

    @Test
    public void testReceiveBooleanTrueAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive(true);
    }

    @Test
    public void testReceiveBooleanFalseAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive(false);
    }

    @Test
    public void testUnregisterAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testUnregister("someaddress");
    }

    @Test
    public void testInvalidType() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testError(new JsonObject().put("type", (Object)"wibble").put("address", (Object)"addr"), "invalid_type");
    }

    @Test
    public void testInvalidJson() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testError("oqiwjdioqwjdoiqjwd", "invalid_json");
    }

    @Test
    public void testMissingType() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testError(new JsonObject().put("address", (Object)"someaddress"), "missing_type");
    }

    @Test
    public void testMissingAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testError(new JsonObject().put("type", (Object)"send").put("body", (Object)"hello world"), "missing_address");
    }

    @Test
    public void testSendNotPermittedDefaultOptions() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions);
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("body", (Object)"hello world"), "access_denied");
    }

    @Test
    public void testSendPermittedAllowAddress() throws Exception {
        String addr = "allow1";
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(addr)));
        this.testSend(addr, "foobar");
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)"allow2").put("body", (Object)"blah"), "access_denied");
    }

    @Test
    public void testSendPermittedAllowAddressRe() throws Exception {
        String addr = "allo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddressRegex(addr)));
        this.testSend("allow1", "foobar");
        this.testSend("allow2", "foobar");
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)"hello").put("body", (Object)"blah"), "access_denied");
    }

    @Test
    public void testSendPermittedMultipleAddresses() throws Exception {
        String addr1 = "allow1";
        String addr2 = "allow2";
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(addr1)).addInboundPermitted(new PermittedOptions().setAddress(addr2)));
        this.testSend("allow1", "foobar");
        this.testSend("allow2", "foobar");
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)"allow3").put("body", (Object)"blah"), "access_denied");
    }

    @Test
    public void testSendPermittedMultipleAddressRe() throws Exception {
        String addr1 = "allo.+";
        String addr2 = "ballo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddressRegex(addr1)).addInboundPermitted(new PermittedOptions().setAddressRegex(addr2)));
        this.testSend("allow1", "foobar");
        this.testSend("allow2", "foobar");
        this.testSend("ballow1", "foobar");
        this.testSend("ballow2", "foobar");
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)"hello").put("body", (Object)"blah"), "access_denied");
    }

    @Test
    public void testSendPermittedMixedAddressRe() throws Exception {
        String addr1 = "allow1";
        String addr2 = "ballo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(addr1)).addInboundPermitted(new PermittedOptions().setAddressRegex(addr2)));
        this.testSend("allow1", "foobar");
        this.testSend("ballow1", "foobar");
        this.testSend("ballow2", "foobar");
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)"hello").put("body", (Object)"blah"), "access_denied");
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)"allow2").put("body", (Object)"blah"), "access_denied");
    }

    @Test
    public void testSendPermittedStructureMatch() throws Exception {
        JsonObject match = new JsonObject().put("fib", (Object)"wib").put("oop", (Object)12);
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setMatch(match)));
        this.testSend(this.addr, match);
        JsonObject json1 = match.copy();
        json1.put("blah", (Object)"foob");
        this.testSend(this.addr, json1);
        json1.remove("fib");
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("body", (Object)json1), "access_denied");
    }

    @Test
    public void testSendPermittedStructureMatchWithAddress() throws Exception {
        JsonObject match = new JsonObject().put("fib", (Object)"wib").put("oop", (Object)12);
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setMatch(match).setAddress(this.addr)));
        this.testSend(this.addr, match);
        JsonObject json1 = match.copy();
        json1.put("blah", (Object)"foob");
        this.testSend(this.addr, json1);
        json1.remove("fib");
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("body", (Object)json1), "access_denied");
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)"otheraddress").put("body", (Object)json1), "access_denied");
    }

    @Test
    public void testRegisterPermittedAllowAddress() throws Exception {
        String addr = "allow1";
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddress(addr)));
        this.testReceive(addr, "foobar");
        this.testError(new JsonObject().put("type", (Object)"register").put("address", (Object)"allow2").put("body", (Object)"blah"), "access_denied");
    }

    @Test
    public void testRegisterPermittedAllowAddressRe() throws Exception {
        String addr = "allo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddressRegex(addr)));
        this.testReceive("allow1", "foobar");
        this.testReceive("allow2", "foobar");
        this.testError(new JsonObject().put("type", (Object)"register").put("address", (Object)"hello").put("body", (Object)"blah"), "access_denied");
    }

    @Test
    public void testRegisterPermittedMultipleAddresses() throws Exception {
        String addr1 = "allow1";
        String addr2 = "allow2";
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddress(addr1)).addOutboundPermitted(new PermittedOptions().setAddress(addr2)));
        this.testReceive("allow1", "foobar");
        this.testReceive("allow2", "foobar");
        this.testError(new JsonObject().put("type", (Object)"register").put("address", (Object)"allow3").put("body", (Object)"blah"), "access_denied");
    }

    @Test
    public void testRegisterPermittedMultipleAddressRe() throws Exception {
        String addr1 = "allo.+";
        String addr2 = "ballo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddressRegex(addr1)).addOutboundPermitted(new PermittedOptions().setAddressRegex(addr2)));
        this.testReceive("allow1", "foobar");
        this.testReceive("allow2", "foobar");
        this.testReceive("ballow1", "foobar");
        this.testReceive("ballow2", "foobar");
        this.testError(new JsonObject().put("type", (Object)"register").put("address", (Object)"hello").put("body", (Object)"blah"), "access_denied");
    }

    @Test
    public void testRegisterPermittedMixedAddressRe() throws Exception {
        String addr1 = "allow1";
        String addr2 = "ballo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddress(addr1)).addOutboundPermitted(new PermittedOptions().setAddressRegex(addr2)));
        this.testReceive("allow1", "foobar");
        this.testReceive("ballow1", "foobar");
        this.testReceive("ballow2", "foobar");
        this.testError(new JsonObject().put("type", (Object)"register").put("address", (Object)"hello").put("body", (Object)"blah"), "access_denied");
        this.testError(new JsonObject().put("type", (Object)"register").put("address", (Object)"allow2").put("body", (Object)"blah"), "access_denied");
    }

    @Test
    public void testRegisterPermittedStructureMatch() throws Exception {
        JsonObject match = new JsonObject().put("fib", (Object)"wib").put("oop", (Object)12);
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setMatch(match)));
        this.testReceive(this.addr, match);
        JsonObject json1 = match.copy();
        json1.put("blah", (Object)"foob");
        this.testReceive(this.addr, json1);
        JsonObject json2 = json1.copy();
        json2.remove("fib");
        this.testReceiveFail(this.addr, json2);
    }

    @Test
    public void testRegisterPermittedStructureMatchWithAddress() throws Exception {
        JsonObject match = new JsonObject().put("fib", (Object)"wib").put("oop", (Object)12);
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setMatch(match).setAddress(this.addr)));
        this.testReceive(this.addr, match);
        JsonObject json1 = match.copy();
        json1.put("blah", (Object)"foob");
        this.testReceive(this.addr, json1);
        JsonObject json2 = json1.copy();
        json2.remove("fib");
        this.testReceiveFail(this.addr, json2);
    }

    @Test
    public void testReplyMessagesInbound() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(this.addr)));
        CountDownLatch latch = new CountDownLatch(1);
        BridgeClient client = new BridgeClient();
        client.connect(this.websocketURI).onComplete(this.onSuccess(v -> {
            MessageConsumer consumer = this.vertx.eventBus().consumer(this.addr);
            consumer.handler(msg -> {
                Object receivedBody = msg.body();
                this.assertEquals("foobar", receivedBody);
                msg.reply((Object)"barfoo");
                consumer.unregister();
            });
            String replyAddress = UUID.randomUUID().toString();
            client.handler((addr, body) -> {
                this.assertEquals(replyAddress, addr);
                this.assertEquals("barfoo", body);
                client.close().onComplete(this.onSuccess(v2 -> latch.countDown()));
            });
            client.request(this.addr, replyAddress, "foobar");
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testReplyMessagesInboundWithHeaders() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(this.addr)));
        CountDownLatch latch = new CountDownLatch(1);
        this.client.webSocket(this.websocketURI, this.onSuccess(ws -> {
            MessageConsumer consumer = this.vertx.eventBus().consumer(this.addr);
            consumer.handler(msg -> {
                Object receivedBody = msg.body();
                this.assertEquals("foobar", receivedBody);
                msg.reply((Object)"barfoo", new DeliveryOptions().addHeader("headfoo", "headbar").addHeader("explode", "m1").addHeader("explode", "m2"));
                consumer.unregister();
            });
            String replyAddress = UUID.randomUUID().toString();
            JsonObject msg2 = new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("replyAddress", (Object)replyAddress).put("body", (Object)"foobar");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("body");
                this.assertEquals("barfoo", rec);
                JsonObject headers = received.getJsonObject("headers");
                this.assertNotNull(headers);
                this.assertEquals("headbar", headers.getString("headfoo"));
                this.assertTrue(headers.getJsonArray("explode").contains((Object)"m1"));
                this.assertTrue(headers.getJsonArray("explode").contains((Object)"m2"));
                ws.closeHandler(v -> latch.countDown());
                ws.close();
            });
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testReplyMessagesOutbound() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddress(this.addr)));
        CountDownLatch latch = new CountDownLatch(1);
        this.client.webSocket(this.websocketURI, this.onSuccess(ws -> {
            JsonObject reg = new JsonObject().put("type", (Object)"register").put("address", (Object)this.addr);
            ws.writeFrame(WebSocketFrame.textFrame((String)reg.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("body");
                this.assertEquals("foobar", rec);
                JsonObject reply = new JsonObject().put("type", (Object)"send").put("address", (Object)received.getString("replyAddress")).put("body", (Object)"barfoo");
                ws.writeFrame(WebSocketFrame.textFrame((String)reply.encode(), (boolean)true));
            });
            this.vertx.setTimer(500L, tid -> this.vertx.eventBus().request(this.addr, (Object)"foobar", res -> {
                if (res.succeeded()) {
                    this.assertEquals("barfoo", ((Message)res.result()).body());
                    ws.closeHandler(v2 -> latch.countDown());
                    ws.close();
                }
            }));
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testReplyToClientTimeout() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions.setReplyTimeout(200L));
        CountDownLatch latch = new CountDownLatch(1);
        this.client.webSocket(this.websocketURI, this.onSuccess(ws -> {
            MessageConsumer consumer = this.vertx.eventBus().consumer(this.addr);
            consumer.handler(msg -> {
                Object receivedBody = msg.body();
                this.assertEquals("foobar", receivedBody);
                this.vertx.setTimer(500L, tid -> {
                    msg.reply((Object)"barfoo");
                    consumer.unregister();
                });
            });
            String replyAddress = UUID.randomUUID().toString();
            JsonObject msg2 = new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("replyAddress", (Object)replyAddress).put("body", (Object)"foobar");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("failureType");
                this.assertEquals("TIMEOUT", rec);
                ws.closeHandler(v -> latch.countDown());
                ws.close();
            });
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testAwaitingReplyToClientTimeout() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions.setReplyTimeout(200L));
        CountDownLatch latch = new CountDownLatch(1);
        this.client.webSocket(this.websocketURI, this.onSuccess(ws -> {
            MessageConsumer consumer = this.vertx.eventBus().consumer(this.addr);
            consumer.handler(msg -> {
                Object receivedBody = msg.body();
                this.assertEquals("one", receivedBody);
                msg.replyAndRequest((Object)"two", rep -> {
                    this.assertTrue(rep.succeeded());
                    Object repReceivedBody = ((Message)rep.result()).body();
                    this.assertEquals("three", repReceivedBody);
                    this.vertx.setTimer(500L, tid -> {
                        ((Message)rep.result()).reply((Object)"four");
                        consumer.unregister();
                    });
                });
            });
            String replyAddress = UUID.randomUUID().toString();
            JsonObject msg2 = new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("replyAddress", (Object)replyAddress).put("body", (Object)"one");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("body");
                this.assertEquals("two", rec);
                String secondReplyAddress = UUID.randomUUID().toString();
                JsonObject rep_msg = new JsonObject().put("type", (Object)"send").put("address", received.getValue("replyAddress")).put("replyAddress", (Object)secondReplyAddress).put("body", (Object)"three");
                ws.writeFrame(WebSocketFrame.textFrame((String)rep_msg.encode(), (boolean)true));
                ws.handler(repBuff -> {
                    String repStr = repBuff.toString();
                    JsonObject repReceived = new JsonObject(repStr);
                    Object repRec = repReceived.getValue("failureType");
                    this.assertEquals("TIMEOUT", repRec);
                    ws.closeHandler(v -> latch.countDown());
                    ws.close();
                });
            });
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testRegisterNotPermittedDefaultOptions() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions);
        this.testError(new JsonObject().put("type", (Object)"register").put("address", (Object)this.addr), "access_denied");
    }

    @Test
    public void testUnregisterNotPermittedDefaultOptions() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions);
        this.testError(new JsonObject().put("type", (Object)"unregister").put("address", (Object)this.addr), "access_denied");
    }

    @Test
    public void testMaxHandlersPerSocket() throws Exception {
        int maxHandlers = 10;
        CountDownLatch latch = new CountDownLatch(1);
        this.sockJSHandler.bridge(new SockJSBridgeOptions(this.allAccessOptions).setMaxHandlersPerSocket(maxHandlers));
        this.client.webSocket(this.websocketURI, this.onSuccess(ws -> {
            JsonObject msg;
            for (int i = 0; i < maxHandlers + 1; ++i) {
                msg = new JsonObject().put("type", (Object)"register").put("address", (Object)this.addr);
                ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
            }
            AtomicInteger cnt = new AtomicInteger();
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("body");
                int c = cnt.getAndIncrement();
                if (c == 0) {
                    this.assertEquals("err", received.getString("type"));
                    this.assertEquals("max_handlers_reached", rec);
                } else if (c >= maxHandlers + 1) {
                    this.fail("Called too many times");
                } else {
                    this.assertEquals("rec", received.getString("type"));
                    this.assertEquals("foobar", rec);
                    if (c == maxHandlers) {
                        this.vertx.setTimer(200L, tid -> latch.countDown());
                    }
                }
            });
            msg = new JsonObject().put("type", (Object)"publish").put("address", (Object)this.addr).put("body", (Object)"foobar");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testMaxAddressLength() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.sockJSHandler.bridge(new SockJSBridgeOptions(this.allAccessOptions).setMaxAddressLength(10));
        this.client.webSocket(this.websocketURI, this.onSuccess(ws -> {
            JsonObject msg = new JsonObject().put("type", (Object)"register").put("address", (Object)"someaddressyqgyuqwdyudyug");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                this.assertEquals("err", received.getString("type"));
                this.assertEquals("max_address_length_reached", received.getString("body"));
                latch.countDown();
            });
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testSendRequiresAuthorityNotLoggedIn() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(this.addr).setRequiredAuthority("admin")));
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("body", (Object)"foo"), "not_logged_in");
    }

    @Test
    public void testSendRequiresAuthorityHasAuthority() throws Exception {
        this.sockJSHandler.bridge((AuthorizationProvider)PropertyFileAuthorization.create((Vertx)this.vertx, (String)"login/loginusers.properties"), this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(this.addr).setRequiredAuthority("bang_sticks")), null);
        this.router.clear();
        LocalSessionStore store = LocalSessionStore.create((Vertx)this.vertx);
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        PropertyFileAuthentication authProvider = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        this.addLoginHandler(this.router, (AuthenticationProvider)authProvider);
        this.router.route("/eventbus/*").handler((Handler)this.sockJSHandler);
        this.testSend("foo");
    }

    @Test
    public void testSendRequiresAuthorityHasnotAuthority() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(this.addr).setRequiredAuthority("pick_nose")));
        this.router.clear();
        LocalSessionStore store = LocalSessionStore.create((Vertx)this.vertx);
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        PropertyFileAuthentication authProvider = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        this.addLoginHandler(this.router, (AuthenticationProvider)authProvider);
        this.router.route("/eventbus/*").handler((Handler)this.sockJSHandler);
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("body", (Object)"foo"), "access_denied");
    }

    private void addLoginHandler(Router router, AuthenticationProvider authProvider) {
        router.route("/eventbus/*").handler(rc -> {
            if (rc.user() == null) {
                UsernamePasswordCredentials authInfo = new UsernamePasswordCredentials("tim", "delicious:sausages");
                HttpServerRequest request = rc.request();
                request.pause();
                authProvider.authenticate((Credentials)authInfo, res -> {
                    request.resume();
                    if (res.succeeded()) {
                        rc.setUser((User)res.result());
                        rc.next();
                    } else {
                        rc.fail(res.cause());
                    }
                });
            }
        });
    }

    @Test
    public void testInvalidClientReplyAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testError(new JsonObject().put("type", (Object)"send").put("address", (Object)this.addr).put("body", (Object)"foo").put("replyAddress", (Object)"thishasmorethan36characters__________"), "invalid_reply_address");
    }

    @Test
    public void testConnectionClosedAfterPingTimeout() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions.setPingTimeout(1000L));
        CountDownLatch latch = new CountDownLatch(1);
        long start = System.currentTimeMillis();
        this.client.webSocket(this.websocketURI, this.onSuccess(ws -> ws.closeHandler(v -> latch.countDown())));
        this.awaitLatch(latch);
        long dur = System.currentTimeMillis() - start;
        this.assertTrue(dur > 1000L && dur < 3000L);
    }

    @Test
    public void testPermittedOptions() {
        PermittedOptions options = new PermittedOptions();
        this.assertEquals(PermittedOptions.DEFAULT_ADDRESS, options.getAddress());
        this.assertEquals(PermittedOptions.DEFAULT_ADDRESS_REGEX, options.getAddressRegex());
        this.assertEquals(PermittedOptions.DEFAULT_REQUIRED_AUTHORITY, options.getRequiredAuthority());
        this.assertEquals(PermittedOptions.DEFAULT_MATCH, options.getMatch());
        String address = TestUtils.randomAlphaString((int)10);
        String addressRegex = TestUtils.randomAlphaString((int)10);
        String requiredAuthority = TestUtils.randomAlphaString((int)10);
        JsonObject match = new JsonObject().put(TestUtils.randomAlphaString((int)10), (Object)TestUtils.randomAlphaString((int)10));
        this.assertSame(options, options.setAddress(address));
        this.assertSame(options, options.setAddressRegex(addressRegex));
        this.assertSame(options, options.setRequiredAuthority(requiredAuthority));
        this.assertSame(options, options.setMatch(match));
        this.assertEquals(address, options.getAddress());
        this.assertEquals(addressRegex, options.getAddressRegex());
        this.assertEquals(requiredAuthority, options.getRequiredAuthority());
        this.assertEquals(match, options.getMatch());
        PermittedOptions copy = new PermittedOptions(options);
        this.assertEquals(address, copy.getAddress());
        this.assertEquals(addressRegex, copy.getAddressRegex());
        this.assertEquals(requiredAuthority, copy.getRequiredAuthority());
        this.assertEquals(match, copy.getMatch());
        this.assertSame(copy, copy.setAddress(TestUtils.randomAlphaString((int)10)));
        this.assertSame(copy, copy.setAddressRegex(TestUtils.randomAlphaString((int)10)));
        this.assertSame(copy, copy.setRequiredAuthority(TestUtils.randomAlphaString((int)10)));
        this.assertSame(copy, copy.setMatch(new JsonObject().put(TestUtils.randomAlphaString((int)10), (Object)TestUtils.randomAlphaString((int)10))));
        this.assertSame(options, options.setAddress(address));
        this.assertSame(options, options.setAddressRegex(addressRegex));
        this.assertSame(options, options.setRequiredAuthority(requiredAuthority));
        this.assertSame(options, options.setMatch(match));
    }

    @Test
    public void testPermittedOptionsJson() {
        String address = TestUtils.randomAlphaString((int)10);
        String addressRegex = TestUtils.randomAlphaString((int)10);
        String requiredAuthority = TestUtils.randomAlphaString((int)10);
        JsonObject match = new JsonObject().put(TestUtils.randomAlphaString((int)10), (Object)TestUtils.randomAlphaString((int)10));
        JsonObject json = new JsonObject().put("address", (Object)address).put("addressRegex", (Object)addressRegex).put("requiredAuthority", (Object)requiredAuthority).put("match", (Object)match);
        PermittedOptions options = new PermittedOptions(json);
        this.assertEquals(address, options.getAddress());
        this.assertEquals(addressRegex, options.getAddressRegex());
        this.assertEquals(requiredAuthority, options.getRequiredAuthority());
        this.assertEquals(match, options.getMatch());
    }

    private void testError(JsonObject msg, String expectedErr) throws Exception {
        this.testError(msg.encode(), expectedErr);
    }

    private void testError(String msg, String expectedErr) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        BridgeClient client = new BridgeClient();
        client.errorHandler((Handler<String>)((Handler)err -> {
            this.assertEquals(expectedErr, err);
            latch.countDown();
        }));
        client.connect(this.websocketURI).compose(v -> ((TransportClient)client.transportClient.result()).write(msg)).onComplete(this.onSuccess(v -> {}));
        this.awaitLatch(latch);
    }

    private void testSend(Object body) throws Exception {
        this.testSend(this.addr, body);
    }

    private void testSend(String address, Object body) throws Exception {
        this.testSend(address, body, false);
    }

    private void testSend(String address, Object body, boolean headers) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        BridgeClient client = new BridgeClient();
        client.connect(this.websocketURI).onComplete(this.onSuccess(v1 -> {
            MessageConsumer consumer = this.vertx.eventBus().consumer(address);
            consumer.handler(msg -> {
                Object receivedBody = msg.body();
                this.assertEquals(body, receivedBody);
                if (headers) {
                    this.checkHeaders((Message)msg);
                }
                consumer.unregister(v2 -> latch.countDown());
            });
            client.send(address, body);
        }));
        this.awaitLatch(latch);
    }

    private void testPublish(Object body) throws Exception {
        this.testPublish(this.addr, body);
    }

    private void testPublish(String address, Object body) throws Exception {
        this.testPublish(address, body, false);
    }

    private void checkHeaders(Message msg) {
        this.assertEquals("val1", msg.headers().get("hdr1"));
        this.assertEquals("val2", msg.headers().get("hdr2"));
    }

    private void testPublish(String address, Object body, boolean headers) throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        BridgeClient client = new BridgeClient();
        client.connect(this.websocketURI).onComplete(this.onSuccess(v1 -> {
            this.vertx.eventBus().consumer(address, msg -> {
                Object receivedBody = msg.body();
                this.assertEquals(body, receivedBody);
                if (headers) {
                    this.checkHeaders((Message)msg);
                }
                latch.countDown();
            });
            this.vertx.eventBus().consumer(address, msg -> {
                Object receivedBody = msg.body();
                this.assertEquals(body, receivedBody);
                if (headers) {
                    this.checkHeaders((Message)msg);
                }
                latch.countDown();
            });
            client.publish(address, body);
        }));
        this.awaitLatch(latch);
    }

    private void testReceive(Object body) throws Exception {
        this.testReceive("someaddress", body);
    }

    private void testReceive(String address, Object body) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        BridgeClient client = new BridgeClient();
        client.handler((addr, rec) -> {
            this.assertEquals(address, addr);
            this.assertEquals(body, rec);
            client.close().onComplete(this.onSuccess(v2 -> latch.countDown()));
        });
        client.connect(this.websocketURI).compose(v -> client.register(address)).onComplete(this.onSuccess(v -> this.vertx.setTimer(200L, tid -> this.vertx.eventBus().send(address, body))));
        this.awaitLatch(latch);
    }

    private void testReceiveFail(String address, Object body) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.client.webSocket(this.websocketURI, this.onSuccess(ws -> {
            JsonObject msg = new JsonObject().put("type", (Object)"register").put("address", (Object)address);
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
            ws.handler(buff -> this.fail("Shouldn't receive anything"));
            this.vertx.setTimer(200L, tid -> {
                this.vertx.eventBus().send(address, body);
                this.vertx.setTimer(200L, tid2 -> latch.countDown());
            });
        }));
        this.awaitLatch(latch);
    }

    private void testUnregister(String address) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.client.webSocket(this.websocketURI, this.onSuccess(ws -> {
            JsonObject msg = new JsonObject().put("type", (Object)"register").put("address", (Object)address);
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                this.assertEquals("rec", received.getString("type"));
                Object rec = received.getValue("body");
                this.assertEquals("foobar", rec);
                JsonObject msg2 = new JsonObject().put("type", (Object)"unregister").put("address", (Object)address);
                ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
                msg2 = new JsonObject().put("type", (Object)"send").put("address", (Object)address).put("body", (Object)"foobar2");
                ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
                this.vertx.setTimer(500L, tid -> latch.countDown());
            });
            msg = new JsonObject().put("type", (Object)"send").put("address", (Object)address).put("body", (Object)"foobar");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
        }));
        this.awaitLatch(latch);
    }

    class BridgeClient {
        private Future<TransportClient> transportClient;
        private BiConsumer<String, Object> handler;
        private Handler<String> errorHandler;

        BridgeClient() {
        }

        public Future<Void> connect(String websocketURI) {
            if (this.transportClient != null) {
                return Future.failedFuture((String)"Already connected");
            }
            this.transportClient = EventbusBridgeTest.this.transport.connect(EventbusBridgeTest.this.client, websocketURI);
            this.transportClient.onSuccess(ws -> ws.handler((Handler<JsonObject>)((Handler)received -> {
                String type = received.getString("type");
                if ("rec".equals(type)) {
                    String address = received.getString("address");
                    if (this.handler != null) {
                        this.handler.accept(address, received.getValue("body"));
                    }
                } else if ("err".equals(type) && this.errorHandler != null) {
                    this.errorHandler.handle((Object)((String)received.getValue("body")));
                }
            })));
            return this.transportClient.mapEmpty();
        }

        private Future<Void> sendOrPublish(String address, String type, String replyAddress, Object body) {
            if (this.transportClient == null) {
                return Future.failedFuture((String)"Not connected");
            }
            return this.transportClient.compose(ws -> {
                JsonObject json = new JsonObject().put("type", (Object)type).put("address", (Object)address).put("body", body);
                if (replyAddress != null) {
                    json.put("replyAddress", (Object)replyAddress);
                }
                return ws.write(json.encode());
            });
        }

        public BridgeClient handler(BiConsumer<String, Object> handler) {
            this.handler = handler;
            return this;
        }

        public BridgeClient errorHandler(Handler<String> handler) {
            this.errorHandler = handler;
            return this;
        }

        public Future<Void> request(String address, String replyAddress, Object body) {
            return this.sendOrPublish(address, "send", replyAddress, body);
        }

        public Future<Void> send(String address, Object body) {
            return this.sendOrPublish(address, "send", null, body);
        }

        public Future<Void> publish(String address, Object body) {
            return this.sendOrPublish(address, "publish", null, body);
        }

        public Future<Void> register(String address) {
            if (this.transportClient == null) {
                return Future.failedFuture((String)"Not connected");
            }
            return this.transportClient.compose(ws -> {
                JsonObject msg = new JsonObject().put("type", (Object)"register").put("address", (Object)address);
                return ws.write(msg.encode());
            });
        }

        public Future<Void> close() {
            if (this.transportClient == null) {
                return Future.failedFuture((String)"Not connected");
            }
            return this.transportClient.compose(TransportClient::close);
        }
    }

    static interface TransportClient {
        public void handler(Handler<JsonObject> var1);

        public Future<Void> write(String var1);

        public Future<Void> close();

        public void abruptClose();
    }

    static enum Transport {
        WS{

            @Override
            Future<TransportClient> connect(HttpClient client, String address) {
                return client.webSocket("/eventbus/400/8ne8e94a/websocket").map(ws -> new TransportClient((WebSocket)ws){
                    private Handler handler;
                    final /* synthetic */ WebSocket val$ws;
                    {
                        this.val$ws = webSocket;
                        this.val$ws.handler(buff -> {
                            String str = buff.toString();
                            if (!str.equals("o") && str.startsWith("a[\"") && str.endsWith("\"]")) {
                                str = str.substring(1);
                                List msgList = JsonCodec.decodeValues((String)str);
                                msgList.forEach(s -> {
                                    Object msg = Json.decodeValue((String)s);
                                    if (msg instanceof JsonObject && this.handler != null) {
                                        this.handler.handle((Object)((JsonObject)msg));
                                    }
                                });
                            }
                        });
                    }

                    @Override
                    public void handler(Handler<JsonObject> handler) {
                        this.handler = handler;
                    }

                    @Override
                    public Future<Void> write(String msg) {
                        String[] str = new String[]{msg};
                        String json = JsonCodec.encode((String[])str);
                        return this.val$ws.writeFrame(WebSocketFrame.textFrame((String)json, (boolean)true));
                    }

                    @Override
                    public Future<Void> close() {
                        return this.val$ws.close();
                    }

                    @Override
                    public void abruptClose() {
                        Channel ch = ((HttpClientConnection)((WebSocketInternal)this.val$ws).connection()).channel();
                        ChannelPromise promise = ch.newPromise();
                        ch.unsafe().close(promise);
                    }
                });
            }
        }
        ,
        RAW_WS{

            @Override
            Future<TransportClient> connect(HttpClient client, String address) {
                return client.webSocket(address).map(ws -> new TransportClient((WebSocket)ws){
                    private Handler handler;
                    final /* synthetic */ WebSocket val$ws;
                    {
                        this.val$ws = webSocket;
                        this.val$ws.handler(buff -> {
                            String str = buff.toString();
                            JsonObject received = new JsonObject(str);
                            if (this.handler != null) {
                                this.handler.handle((Object)received);
                            }
                        });
                    }

                    @Override
                    public void handler(Handler<JsonObject> handler) {
                        this.handler = handler;
                    }

                    @Override
                    public Future<Void> write(String msg) {
                        return this.val$ws.writeFrame(WebSocketFrame.textFrame((String)msg, (boolean)true));
                    }

                    @Override
                    public Future<Void> close() {
                        return this.val$ws.close();
                    }

                    @Override
                    public void abruptClose() {
                        Channel ch = ((HttpClientConnection)((WebSocketInternal)this.val$ws).connection()).channel();
                        ChannelPromise promise = ch.newPromise();
                        ch.unsafe().close(promise);
                    }
                });
            }
        };


        abstract Future<TransportClient> connect(HttpClient var1, String var2);
    }
}

