/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.JWTAuthHandler;
import java.util.Arrays;
import org.junit.Before;
import org.junit.Test;

public class JWTAuthHandlerTest
extends WebTestBase {
    JWTAuth authProvider;

    @Before
    public void setup() throws Exception {
        this.authProvider = JWTAuth.create((Vertx)this.vertx, (JWTAuthOptions)new JWTAuthOptions().setKeyStore(new KeyStoreOptions().setType("jceks").setPath("keystore.jceks").setPassword("secret")));
    }

    @Test
    public void testLogin() throws Exception {
        Handler handler = rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("paulo", rc.user().attributes().getJsonObject("accessToken").getString("sub"));
            rc.response().end("Welcome to the protected resource!");
        };
        this.router.route("/protected/*").handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {}, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(new JsonObject().put("sub", (Object)"paulo"), new JWTOptions())), 200, "OK", "Welcome to the protected resource!");
    }

    @Test
    public void testLoginFail() throws Exception {
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        this.router.route("/protected/*").handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, 401, "Unauthorized", null);
        String token = this.authProvider.generateToken(new JsonObject().put("sub", (Object)"paulo"), new JWTOptions());
        this.testRequest(HttpMethod.GET, "/protected/somepage", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer x" + token), 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", (HttpClientRequest req) -> req.putHeader("Authorization", "Basic " + token), 401, "Unauthorized", null);
    }

    @Test
    public void testLoginWithScopes() throws Exception {
        this.router.route().handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider).withScopes(Arrays.asList("a", "b"))).handler(RoutingContext::end);
        JsonObject payloadA = new JsonObject().put("sub", (Object)"Paulo").put("scope", (Object)String.join((CharSequence)" ", Arrays.asList("a", "b")));
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(payloadA)), 200, "OK", null);
        JsonObject payloadB = new JsonObject().put("sub", (Object)"Paulo").put("scope", (Object)new JsonArray().add((Object)"a").add((Object)"b"));
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(payloadB)), 200, "OK", null);
    }

    @Test
    public void testLoginWithMissingScopes() throws Exception {
        this.router.route().handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider).withScopes(Arrays.asList("a", "b", "c"))).handler(RoutingContext::end);
        JsonObject payloadA = new JsonObject().put("sub", (Object)"Paulo").put("scope", (Object)String.join((CharSequence)" ", Arrays.asList("a", "b")));
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(payloadA)), 403, "Forbidden", null);
        JsonObject payloadB = new JsonObject().put("sub", (Object)"Paulo").put("scope", (Object)new JsonArray().add((Object)"a").add((Object)"b"));
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(payloadB)), 403, "Forbidden", null);
    }

    @Test
    public void testLoginWithScopeDelimiter() throws Exception {
        this.router.route().handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider).withScopes(Arrays.asList("a", "b")).scopeDelimiter(",")).handler(RoutingContext::end);
        JsonObject payloadA = new JsonObject().put("sub", (Object)"Paulo").put("scope", (Object)String.join((CharSequence)" ", Arrays.asList("a", "b")));
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(payloadA)), 403, "Forbidden", null);
        JsonObject payloadB = new JsonObject().put("sub", (Object)"Paulo").put("scope", (Object)String.join((CharSequence)",", Arrays.asList("a", "b")));
        this.testRequest(HttpMethod.GET, "/", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(payloadB)), 200, "OK", null);
    }
}

