/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.WebSocketFrameType;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSProtocolTest;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.test.core.TestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.junit.Test;

public class SockJSHandlerTest
extends WebTestBase {
    private static final Logger log = LoggerFactory.getLogger(SockJSHandlerTest.class);
    private static final Buffer SOCKJS_CLOSE_REPLY = Buffer.buffer((String)"c[3000,\"Go away!\"]");

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.router.route().handler((Handler)BodyHandler.create());
        SockJSProtocolTest.installTestApplications(this.router, this.vertx);
    }

    @Test
    public void testGreeting() {
        this.waitFor(2);
        this.testGreeting("/echo/");
        this.testGreeting("/echo");
        this.await();
    }

    private void testGreeting(String uri) {
        this.client.request(HttpMethod.GET, uri).compose(req -> req.send().compose(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("text/plain; charset=UTF-8", resp.getHeader("content-type"));
            return resp.body();
        })).onComplete(this.onSuccess(buff -> {
            this.assertEquals("Welcome to SockJS!\n", buff.toString());
            this.complete();
        }));
    }

    @Test
    public void testNotFound() {
        this.waitFor(7);
        this.testNotFound("/echo/a");
        this.testNotFound("/echo/a.html");
        this.testNotFound("/echo/a/a");
        this.testNotFound("/echo/a/a/");
        this.testNotFound("/echo/a/");
        this.testNotFound("/echo//");
        this.testNotFound("/echo///");
        this.await();
    }

    @Test
    public void testSendWebsocketContinuationFrames() {
        this.client.webSocket("/echo/websocket", this.onSuccess(ws -> {
            int size = 65535;
            Buffer buffer1 = TestUtils.randomBuffer((int)size);
            Buffer buffer2 = TestUtils.randomBuffer((int)size);
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buffer1, (boolean)false));
            ws.writeFrame(WebSocketFrame.continuationFrame((Buffer)buffer2, (boolean)true));
            Buffer received = Buffer.buffer();
            ws.handler(buff -> {
                received.appendBuffer(buff);
                if (received.length() == size * 2) {
                    this.testComplete();
                }
            });
        }));
        this.await();
    }

    @Test
    public void testCombineBinaryContinuationFramesRawWebSocket() throws InterruptedException {
        String serverPath = "/combine";
        AtomicReference serverReceivedMessage = new AtomicReference();
        this.setupSockJsServer(serverPath, (sock, requestBuffer) -> {
            serverReceivedMessage.set(requestBuffer);
            sock.write(Buffer.buffer((String)"reply"));
            sock.close();
        });
        Buffer largeMessage = Buffer.buffer((String)TestUtils.randomAlphaString((int)30));
        WebSocketFrame frame1 = WebSocketFrame.binaryFrame((Buffer)largeMessage.slice(0, 10), (boolean)false);
        WebSocketFrame frame2 = WebSocketFrame.continuationFrame((Buffer)largeMessage.slice(10, 20), (boolean)false);
        WebSocketFrame frame3 = WebSocketFrame.continuationFrame((Buffer)largeMessage.slice(20, largeMessage.length()), (boolean)true);
        WebSocket ws = this.setupRawWebsocketClient(serverPath);
        ws.writeFrame(frame1);
        ws.writeFrame(frame2);
        ws.writeFrame(frame3);
        this.await(5L, TimeUnit.SECONDS);
        this.assertEquals("Server did not combine continuation frames correctly", largeMessage, serverReceivedMessage.get());
    }

    @Test
    public void testSplitLargeReplyRawWebSocket() throws InterruptedException {
        String serverPath = "/split";
        String largeReply = TestUtils.randomAlphaString((int)327680);
        Buffer largeReplyBuffer = Buffer.buffer((String)largeReply);
        this.setupSockJsServer(serverPath, (sock, requestBuffer) -> {
            sock.write(largeReplyBuffer);
            sock.close();
        });
        Buffer totalReplyBuffer = Buffer.buffer((int)largeReplyBuffer.length());
        AtomicInteger receivedReplies = new AtomicInteger(0);
        WebSocket ws = this.setupRawWebsocketClient(serverPath);
        ws.handler(replyBuffer -> {
            totalReplyBuffer.appendBuffer(replyBuffer);
            receivedReplies.incrementAndGet();
        });
        ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)Buffer.buffer((String)"hello"), (boolean)true));
        this.await(5L, TimeUnit.SECONDS);
        int receivedReplyCount = receivedReplies.get();
        this.assertEquals("Combined reply on client should equal message from server", largeReplyBuffer, totalReplyBuffer);
        this.assertTrue("Should have received > 1 reply frame, actually received " + receivedReplyCount, receivedReplyCount > 1);
    }

    @Test
    public void testTextFrameRawWebSocket() throws InterruptedException {
        String serverPath = "/textecho";
        this.setupSockJsServer(serverPath, this::echoRequest);
        String message = "hello";
        AtomicReference receivedReply = new AtomicReference();
        WebSocket ws = this.setupRawWebsocketClient(serverPath);
        ws.handler(replyBuffer -> receivedReply.set(replyBuffer.toString()));
        ws.writeFrame(WebSocketFrame.textFrame((String)message, (boolean)true));
        this.await(5L, TimeUnit.SECONDS);
        this.assertEquals("Client reply should have matched request", message, receivedReply.get());
    }

    @Test
    public void testTextFrameSockJs() throws InterruptedException {
        String serverPath = "/text-sockjs";
        this.setupSockJsServer(serverPath, this::echoRequest);
        ArrayList<Buffer> receivedMessages = new ArrayList<Buffer>();
        WebSocket openedWebSocket = this.setupSockJsClient(serverPath, receivedMessages);
        String messageToSend = "[\"testMessage\"]";
        openedWebSocket.writeFrame(WebSocketFrame.textFrame((String)messageToSend, (boolean)true));
        this.await(10L, TimeUnit.SECONDS);
        this.assertEquals("Client should have received 2 messages: the reply and the close.", 2L, receivedMessages.size());
        Buffer expectedReply = Buffer.buffer((String)("a" + messageToSend));
        this.assertEquals("Client reply should have matched request", expectedReply, receivedMessages.get(0));
        this.assertEquals("Final message should have been a close", SOCKJS_CLOSE_REPLY, receivedMessages.get(1));
    }

    @Test
    public void testCombineTextFrameSockJs() throws InterruptedException {
        String serverPath = "/text-combine-sockjs";
        this.setupSockJsServer(serverPath, this::echoRequest);
        ArrayList<Buffer> receivedMessages = new ArrayList<Buffer>();
        WebSocket openedWebSocket = this.setupSockJsClient(serverPath, receivedMessages);
        Buffer largeMessage = Buffer.buffer((String)("[\"" + TestUtils.randomAlphaString((int)30) + "\"]"));
        WebSocketFrameImpl frame1 = new WebSocketFrameImpl(WebSocketFrameType.TEXT, largeMessage.slice(0, 10).getByteBuf(), false);
        WebSocketFrame frame2 = WebSocketFrame.continuationFrame((Buffer)largeMessage.slice(10, 20), (boolean)false);
        WebSocketFrame frame3 = WebSocketFrame.continuationFrame((Buffer)largeMessage.slice(20, largeMessage.length()), (boolean)true);
        log.debug((Object)("Client sending " + frame1.textData()));
        openedWebSocket.writeFrame((WebSocketFrame)frame1);
        log.debug((Object)("Client sending " + frame2.textData()));
        openedWebSocket.writeFrame(frame2);
        log.debug((Object)("Client sending " + frame3.textData()));
        openedWebSocket.writeFrame(frame3);
        this.await(10L, TimeUnit.SECONDS);
        this.assertEquals("Client should have received 2 messages: the reply and the close.", 2L, receivedMessages.size());
        Buffer expectedReply = Buffer.buffer((String)("a" + largeMessage.toString()));
        this.assertEquals("Client reply should have matched request", expectedReply, receivedMessages.get(0));
        this.assertEquals("Final message should have been a close", SOCKJS_CLOSE_REPLY, receivedMessages.get(1));
    }

    @Test
    public void testSplitLargeReplySockJs() throws InterruptedException {
        String serverPath = "/large-reply-sockjs";
        String largeMessage = TestUtils.randomAlphaString((int)131072);
        Buffer largeReplyBuffer = Buffer.buffer((String)largeMessage);
        this.setupSockJsServer(serverPath, (sock, requestBuffer) -> {
            sock.write(largeReplyBuffer);
            sock.close();
        });
        ArrayList<Buffer> receivedMessages = new ArrayList<Buffer>();
        WebSocket openedWebSocket = this.setupSockJsClient(serverPath, receivedMessages);
        String messageToSend = "[\"hello\"]";
        openedWebSocket.writeFrame(WebSocketFrame.textFrame((String)messageToSend, (boolean)true));
        this.await(5L, TimeUnit.SECONDS);
        int receivedReplyCount = receivedMessages.size();
        this.assertTrue("Should have received > 2 reply frame, actually received " + receivedReplyCount, receivedReplyCount > 2);
        Buffer expectedReplyBuffer = Buffer.buffer((String)"a[\"").appendBuffer(largeReplyBuffer).appendBuffer(Buffer.buffer((String)"\"]"));
        Buffer clientReplyBuffer = this.combineReplies(receivedMessages.subList(0, receivedMessages.size() - 1));
        this.assertEquals(String.format("Combined reply on client (length %s) should equal message from server (%s)", clientReplyBuffer.length(), expectedReplyBuffer.length()), expectedReplyBuffer, clientReplyBuffer);
        Buffer finalMessage = (Buffer)receivedMessages.get(receivedMessages.size() - 1);
        this.assertEquals("Final message should have been a close", SOCKJS_CLOSE_REPLY, finalMessage);
    }

    private Buffer combineReplies(List<Buffer> receivedMessages) {
        Buffer combinedReply = Buffer.buffer();
        for (Buffer receivedMessage : receivedMessages) {
            combinedReply.appendBuffer(receivedMessage);
        }
        return combinedReply;
    }

    private void echoRequest(SockJSSocket sock, Buffer requestBuffer) {
        log.debug((Object)("Server received " + requestBuffer));
        log.debug((Object)("Server sending " + requestBuffer));
        sock.write(requestBuffer);
        sock.exceptionHandler(null);
        sock.close();
    }

    private void setupSockJsServer(String serverPath, BiConsumer<SockJSSocket, Buffer> serverBufferHandler) {
        String path = serverPath;
        this.router.mountSubRouter(path, SockJSHandler.create((Vertx)this.vertx).socketHandler(sock -> {
            sock.handler(buffer -> serverBufferHandler.accept((SockJSSocket)sock, (Buffer)buffer));
            sock.exceptionHandler(arg_0 -> ((SockJSHandlerTest)this).fail(arg_0));
        }));
    }

    private WebSocket setupSockJsClient(String serverPath, List<Buffer> receivedMessagesCollector) throws InterruptedException {
        String requestURI = serverPath + "/000/000/websocket";
        AtomicReference openedWebSocketReference = new AtomicReference();
        CountDownLatch openSocketCountDown = new CountDownLatch(1);
        this.client.webSocket(requestURI, this.onSuccess(ws -> {
            openedWebSocketReference.set(ws);
            ws.handler(replyBuffer -> {
                log.debug((Object)("Client received " + replyBuffer));
                String textReply = replyBuffer.toString();
                if ("o".equals(textReply)) {
                    openSocketCountDown.countDown();
                } else {
                    receivedMessagesCollector.add((Buffer)replyBuffer);
                }
            });
            ws.endHandler(v -> this.testComplete());
            ws.exceptionHandler(arg_0 -> ((SockJSHandlerTest)this).fail(arg_0));
        }));
        openSocketCountDown.await(5L, TimeUnit.SECONDS);
        return (WebSocket)openedWebSocketReference.get();
    }

    private WebSocket setupRawWebsocketClient(String serverPath) throws InterruptedException {
        String requestURI = serverPath + "/websocket";
        AtomicReference openedWebSocketReference = new AtomicReference();
        CountDownLatch openSocketCountDown = new CountDownLatch(1);
        this.client.webSocket(requestURI, this.onSuccess(ws -> {
            openedWebSocketReference.set(ws);
            openSocketCountDown.countDown();
            ws.endHandler(v -> this.testComplete());
            ws.exceptionHandler(arg_0 -> ((SockJSHandlerTest)this).fail(arg_0));
        }));
        openSocketCountDown.await(5L, TimeUnit.SECONDS);
        return (WebSocket)openedWebSocketReference.get();
    }

    private void testNotFound(String uri) {
        this.client.request(HttpMethod.GET, uri, this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(404L, resp.statusCode());
            this.complete();
        }))));
    }

    @Test
    public void testWebContext() throws Exception {
        this.waitFor(2);
        SessionStore store = SessionStore.create((Vertx)this.vertx);
        SessionHandler handler = SessionHandler.create((SessionStore)store).setCookieless(true);
        CompletableFuture sessionID = new CompletableFuture();
        CompletableFuture sessionUser = new CompletableFuture();
        this.router.mountSubRouter("/webcontext", SockJSHandler.create((Vertx)this.vertx).socketHandler(sock -> {
            JsonObject principal = new JsonObject().put("key", (Object)"val");
            Session oldSession = sock.webSession();
            Session session = handler.newSession(sock.routingContext());
            User user = User.create((JsonObject)principal);
            handler.setUser(sock.routingContext(), user, result -> {
                this.assertFalse(result.failed());
                this.assertNotSame(session, oldSession);
                this.assertEquals(session, sock.webSession());
                sock.routingContext().setSession(session);
                this.assertEquals(sock.webSession(), sock.routingContext().session());
                this.assertEquals(sock.webUser(), sock.routingContext().user());
                this.assertEquals(sock.webUser(), user);
                this.assertEquals(session, sock.webSession());
                this.assertEquals(session, store.get(session.id()).result());
                sessionID.complete(session.id());
                sessionUser.complete(sock.webUser());
            });
        }));
        this.router.mountSubRouter("/webcontextuser", SockJSHandler.create((Vertx)this.vertx).socketHandler(sock -> {
            Session session = null;
            try {
                session = (Session)store.get((String)sessionID.get()).result();
            }
            catch (InterruptedException | ExecutionException e) {
                this.fail();
            }
            sock.routingContext().setSession(session);
            try {
                this.assertEquals(sessionID.get(), ((Session)store.get((String)sessionID.get()).result()).id());
                this.assertEquals(sessionUser.get(), sock.webUser());
            }
            catch (InterruptedException | ExecutionException e) {
                this.fail();
            }
            this.complete();
        }));
        this.client.webSocket(new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setURI("/webcontext/websocket"), this.onSuccess(ws -> this.client.webSocket(new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setURI("/webcontextuser/websocket"), this.onSuccess(wsuser -> this.complete()))));
        this.await();
    }

    @Test
    public void testCookiesRemoved() throws Exception {
        this.waitFor(2);
        this.router.mountSubRouter("/cookiesremoved", SockJSHandler.create((Vertx)this.vertx).socketHandler(sock -> {
            MultiMap headers = sock.headers();
            String cookieHeader = headers.get("cookie");
            this.assertNotNull(cookieHeader);
            this.assertEquals("JSESSIONID=wibble", cookieHeader);
            this.complete();
        }));
        MultiMap headers = HttpHeaders.headers();
        headers.add("cookie", "JSESSIONID=wibble");
        headers.add("cookie", "flibble=floob");
        this.client.webSocket(new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setURI("/cookiesremoved/websocket").setHeaders(headers), this.onSuccess(ws -> this.complete()));
        this.await();
    }

    @Test
    public void testTimeoutCloseCode() {
        this.router.mountSubRouter("/ws-timeout", SockJSHandler.create((Vertx)this.vertx).bridge(new SockJSBridgeOptions().setPingTimeout(1L)));
        this.client.webSocket("/ws-timeout/websocket", this.onSuccess(ws -> ws.frameHandler(frame -> {
            if (frame.isClose()) {
                this.assertEquals(1001L, frame.closeStatusCode());
                this.assertEquals("Session expired", frame.closeReason());
                this.testComplete();
            }
        })));
        this.await();
    }

    @Test
    public void testInvalidMessageCode() {
        this.router.mountSubRouter("/ws-timeout", SockJSHandler.create((Vertx)this.vertx).bridge(new SockJSBridgeOptions().addInboundPermitted(new PermittedOptions().setAddress("SockJSHandlerTest.testInvalidMessageCode"))));
        this.vertx.eventBus().consumer("SockJSHandlerTest.testInvalidMessageCode", msg -> msg.reply((Object)new JsonObject()));
        this.client.webSocket("/ws-timeout/websocket", this.onSuccess(ws -> {
            ws.writeFinalBinaryFrame(Buffer.buffer((String)"durp!"));
            ws.frameHandler(frame -> {
                if (!frame.isClose()) {
                    JsonObject msg = new JsonObject(frame.binaryData());
                    this.assertEquals("err", msg.getString("type"));
                    this.assertEquals("invalid_json", msg.getString("body"));
                    this.testComplete();
                    ws.close();
                }
            });
        }));
        this.await();
    }
}

