/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"io.virtdata.annotations.Service"})
public class ServiceProcessor
extends AbstractProcessor {
    private static Pattern packageNamePattern = Pattern.compile("(?<packageName>.+)?\\.(?<className>.+)");
    private Filer filer;
    private Map<String, String> options;
    private Elements elementUtils;
    private Messager messenger;
    private SourceVersion sourceVersion;
    private Types typeUtils;
    private Map<String, Set<Element>> types = new HashMap<String, Set<Element>>();
    private Set<ModuleElement> moduleElements = new HashSet<ModuleElement>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.options = processingEnv.getOptions();
        this.elementUtils = processingEnv.getElementUtils();
        this.messenger = processingEnv.getMessager();
        this.sourceVersion = processingEnv.getSourceVersion();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList ts = new ArrayList();
        try {
            for (String annotationType : this.getSupportedAnnotationTypes()) {
                Class<?> annotationClass = Class.forName(annotationType);
                Set<? extends Element> tsms = roundEnv.getElementsAnnotatedWith(annotationClass);
                for (Element element : tsms) {
                    String serviceClass = null;
                    for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                        DeclaredType atype = annotationMirror.getAnnotationType();
                        if (!annotationType.equals(atype.toString())) continue;
                        List valueKeys = annotationMirror.getElementValues().keySet().stream().filter(k -> k.toString().equals("value()")).collect(Collectors.toList());
                        if (valueKeys.size() == 0) {
                            this.messenger.printMessage(Diagnostic.Kind.ERROR, "Annotation missing required value");
                            return false;
                        }
                        AnnotationValue annotationValue = annotationMirror.getElementValues().get(valueKeys.get(0));
                        serviceClass = annotationValue.getValue().toString();
                        Set typeSet = this.types.computeIfAbsent(serviceClass, s -> new HashSet());
                        TypeElement typeElem = (TypeElement)element;
                        typeSet.add(typeElem);
                        ModuleElement moduleElem = (ModuleElement)typeElem.getEnclosingElement().getEnclosingElement();
                        this.moduleElements.add(moduleElem);
                        this.messenger.printMessage(Diagnostic.Kind.NOTE, "Recording service entry for implementation of " + serviceClass + ": " + typeElem.toString());
                    }
                }
            }
            if (roundEnv.processingOver()) {
                this.writeMetaInfServices();
            }
        }
        catch (Exception e) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, e.toString());
        }
        return true;
    }

    private void writeJPMSServices(FileObject extantModuleInfo) {
        try {
            Reader reader = extantModuleInfo.openReader(false);
            StringWriter extantInfo = new StringWriter();
            reader.transferTo(extantInfo);
            String moduleInfo = extantInfo.getBuffer().toString();
            String jpmsEntries = this.getJPMSEntries();
            String newModuleInfo = moduleInfo.replaceFirst("// AUTOSERVICES *\n", jpmsEntries);
            if (moduleInfo.equals(newModuleInfo)) {
                this.messenger.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "No changes to module info file.");
            } else {
                FileObject toWrite = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "module-info.java", new Element[0]);
                Writer moduleWriter = toWrite.openWriter();
                moduleWriter.write(newModuleInfo);
                moduleWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getJPMSEntries() {
        StringBuilder sb = new StringBuilder();
        for (String serviceType : this.types.keySet()) {
            sb.append("// Added by annotation processor " + this.getClass().getCanonicalName()).append("\n");
            sb.append("  provides " + serviceType + " with");
            for (Element element : this.types.get(serviceType)) {
                Name name = ((TypeElement)element).getQualifiedName();
                sb.append("\n   ").append(name.toString()).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(";\n");
        }
        return sb.toString();
    }

    private FileObject openModuleInfo() {
        if (this.moduleElements.size() != 1) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "found more or less than one module: " + this.moduleElements.stream().map(ModuleElement::getQualifiedName).collect(Collectors.joining(",")));
            throw new RuntimeException("Unable to continue");
        }
        String moduleName = this.moduleElements.stream().findFirst().map(ModuleElement::getQualifiedName).map(String::valueOf).orElseThrow();
        try {
            FileObject resource = this.filer.getResource(StandardLocation.SOURCE_PATH, "", "module-info.java");
            this.messenger.printMessage(Diagnostic.Kind.OTHER, "This module IS JPMS modular, adding services.");
            return resource;
        }
        catch (IOException ignored) {
            this.messenger.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "This module is not JPMS modular, falling back to classpath + META-INF services");
            return null;
        }
    }

    private void writeMetaInfServices() throws IOException {
        for (String serviceType : this.types.keySet()) {
            this.messenger.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Writing services file for " + serviceType);
            Set<Element> tsms = this.types.get(serviceType);
            Element[] elements = new ArrayList<Element>(tsms).toArray(new Element[0]);
            FileObject servicesFile = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + serviceType, elements);
            Writer w = servicesFile.openWriter();
            for (Element tsm : tsms) {
                Name className = ((TypeElement)tsm).getQualifiedName();
                w.write(className.toString() + "\n");
            }
            w.close();
        }
    }
}

