/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors.internals;

import io.virtdata.autodoctypes.DocForFunc;
import io.virtdata.processors.internals.FuncEnumerator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class EnhancedModuleInfoWriter
implements FuncEnumerator.Listener {
    private final String suffix;
    private final Set<String> classes = new HashSet<String>();
    private Filer filer;
    private Messager messenger;

    public EnhancedModuleInfoWriter(Filer filer, Messager messenger, String suffix) {
        this.filer = filer;
        this.messenger = messenger;
        this.suffix = suffix;
    }

    private String getEntries() {
        StringBuilder sb = new StringBuilder();
        sb.append("  provides javax.annotation.processing.Processor with\n");
        for (String clazz : this.classes) {
            sb.append("   ").append(clazz).append(",\n");
        }
        sb.setLength(sb.length() - 1);
        sb.append(";\n");
        return sb.toString();
    }

    private String readTemplate() throws IOException {
        HashSet serviceClasses = new HashSet();
        FileObject moduleInfoFile = this.filer.getResource(StandardLocation.SOURCE_PATH, "", "module-info.java");
        Reader reader = moduleInfoFile.openReader(false);
        StringWriter writer = new StringWriter();
        reader.transferTo(writer);
        String existing = writer.getBuffer().toString();
        this.messenger.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "existing module-info:\n" + existing);
        this.messenger.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "entries to add:\n" + this.getEntries());
        return existing;
    }

    static void writeServiceFile(Collection<String> services, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        for (String service : services) {
            writer.write(service);
            writer.newLine();
        }
        writer.flush();
    }

    @Override
    public void onFunctionModel(DocForFunc functionDoc) {
        this.classes.add(functionDoc.getPackageName() + "." + functionDoc.getClassName());
    }

    public void finalFlush(List<String> classNames) {
        this.getEntries();
    }
}

