/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.services;

import io.virtdata.services.ModuleDataService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModuleDataService
implements ModuleDataService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultModuleDataService.class);

    @Override
    public InputStream getInputStream(Path resourcePath, Path ... searchIn) {
        try {
            Path initialPath = ModuleDataService.DATAPATH.resolve(resourcePath);
            InputStream found = this.getClass().getModule().getResourceAsStream(initialPath.toString());
            if (found != null) {
                return found;
            }
        }
        catch (IOException initialPath) {
            // empty catch block
        }
        ArrayList<Path> searchedPaths = new ArrayList<Path>();
        for (Path searchPathPrefix : searchIn) {
            InputStream stream = null;
            try {
                Path candidatePath = ModuleDataService.DATAPATH.resolve(searchPathPrefix.resolve(resourcePath));
                stream = this.getClass().getModule().getResourceAsStream(candidatePath.toString());
                if (stream != null) {
                    return stream;
                }
                searchedPaths.add(candidatePath);
                logger.trace("did not find resource in " + candidatePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append(" (from:").append(stacktrace[2].getModuleName()).append(")");
        return this.getClass().getModule().getName() + "/" + this.getClass().getSimpleName() + sb.toString();
    }
}

