/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.services;

import io.virtdata.autodoctypes.DocFuncData;
import io.virtdata.services.FunctionFinderService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.module.ModuleReader;
import java.lang.module.ResolvedModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ModuleFunctionFinder
implements FunctionFinderService {
    public Module getModuleOfFinder() {
        return this.getClass().getModule();
    }

    @Override
    public List<FunctionFinderService.Path> getFunctionPaths() {
        try {
            Module module = this.getModuleOfFinder();
            ResolvedModule thisModuleResolved = module.getLayer().configuration().findModule(module.getName()).orElseThrow();
            ModuleReader moduleReader = thisModuleResolved.reference().open();
            InputStream funcfile = moduleReader.open("FUNCTION-DATA/functions.txt").orElse(null);
            if (funcfile == null) {
                throw new RuntimeException(this.getClass().getCanonicalName() + " unable to open FUNCTION-DATA/functions.txt from a module that has a DocFuncDataFinder provided, module:" + this.getModuleOfFinder().getName());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(funcfile));
            List<FunctionFinderService.Path> names = reader.lines().filter(Objects::nonNull).filter(s -> !s.isEmpty()).map(String::trim).distinct().sorted().map(funcName -> new FunctionFinderService.Path(module.getName(), (String)funcName, this)).collect(Collectors.toList());
            return names;
        }
        catch (Exception e) {
            throw new RuntimeException("error while resolving function names: " + e.getMessage(), e);
        }
    }

    @Override
    public List<? extends DocFuncData> getFuncDataForModule() {
        List<FunctionFinderService.Path> funcNamesForModule = this.getFunctionPaths();
        ArrayList docFuncDataList = new ArrayList();
        return funcNamesForModule.stream().map(f -> f.instantiateDocs()).collect(Collectors.toList());
    }

    public String toString() {
        int[] elems;
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (int elem : elems = new int[]{2}) {
            StackTraceElement ste = stacktrace[elem];
            sb.append(" (from:").append(ste.getModuleName()).append(")");
        }
        return this.getClass().getModule().getName() + "/" + this.getClass().getSimpleName() + sb.toString();
    }
}

