/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.PerThreadMapper;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.autodoctypes.DocForFunc;
import io.virtdata.processors.internals.ClassNameListener;
import io.virtdata.processors.internals.FuncEnumerator;
import io.virtdata.processors.internals.FunctionDocInfoWriter;
import io.virtdata.processors.internals.ProcessorFileUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@SupportedAnnotationTypes(value={"io.virtdata.annotations.ThreadSafeMapper", "io.virtdata.annotations.PerThreadMapper"})
public class FunctionDocInfoProcessor
extends AbstractProcessor {
    public static final String AUTOSUFFIX = "AutoDocsInfo";
    public static final String FUNCTIONS_FILE = "FUNCTION-DATA/functions.txt";
    private static Pattern packageNamePattern = Pattern.compile("(?<packageName>.+)?\\.(?<className>.+)");
    private static Pattern inheritDocPattern = Pattern.compile("(?ms)(?<pre>.*)(?<inherit>\\{@inheritDoc})(?<post>.*)$");
    private Filer filer;
    private Map<String, String> options;
    private Elements elementUtils;
    private Messager messenger;
    private SourceVersion sourceVersion;
    private Types typeUtils;
    private FuncEnumerator enumerator;
    private ClassNameListener classNameListener;
    private List<String> functionNames = new ArrayList<String>();
    private Set<ModuleElement> moduleElements = new HashSet<ModuleElement>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.options = processingEnv.getOptions();
        this.elementUtils = processingEnv.getElementUtils();
        this.messenger = processingEnv.getMessager();
        this.sourceVersion = processingEnv.getSourceVersion();
        this.typeUtils = processingEnv.getTypeUtils();
        this.enumerator = new FuncEnumerator(this.typeUtils, this.elementUtils, this.filer);
        this.classNameListener = new ClassNameListener();
        this.enumerator.addListener(this.classNameListener);
        this.enumerator.addListener(new FunctionDocInfoWriter(this.filer, this.messenger, AUTOSUFFIX));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.messenger.printMessage(Diagnostic.Kind.NOTE, "last round of annotation processing? " + roundEnv.processingOver());
        ArrayList<Element> ts = new ArrayList<Element>();
        Class<ThreadSafeMapper> tsmc = ThreadSafeMapper.class;
        Class<PerThreadMapper> ptmc = PerThreadMapper.class;
        ts.addAll(roundEnv.getElementsAnnotatedWith(tsmc));
        ts.addAll(roundEnv.getElementsAnnotatedWith(ptmc));
        for (Element classElem : ts) {
            if (classElem.getKind() != ElementKind.CLASS) {
                throw new RuntimeException("Unexpected kind of element: " + classElem.getKind() + " for " + classElem.toString());
            }
            Name qualifiedName = ((TypeElement)classElem).getQualifiedName();
            try {
                ModuleElement me = (ModuleElement)classElem.getEnclosingElement().getEnclosingElement();
                this.moduleElements.add(me);
            }
            catch (Exception e) {
                this.messenger.printMessage(Diagnostic.Kind.ERROR, "class " + qualifiedName + " must be contained in a JPMS module.");
                throw new RuntimeException("class " + qualifiedName + " must be contained in a JPMS module.");
            }
            Matcher pnm = packageNamePattern.matcher(qualifiedName);
            if (!pnm.matches()) {
                throw new RuntimeException("Unable to match qualified name for package and name: " + qualifiedName);
            }
            String packageName = pnm.group("packageName");
            String simpleClassName = pnm.group("className");
            String classDoc = this.elementUtils.getDocComment(classElem);
            classDoc = classDoc == null ? "" : this.cleanJavadoc(classDoc);
            classDoc = this.inheritDocs(classDoc, classElem);
            this.enumerator.onClass(packageName, simpleClassName, classDoc);
            this.functionNames.add(packageName + "." + simpleClassName);
            Categories categoryAnnotation = classElem.getAnnotation(Categories.class);
            if (categoryAnnotation != null) {
                Category[] value = categoryAnnotation.value();
                this.enumerator.onCategories(value);
            }
            boolean foundApply = false;
            Element applyMethodElem = null;
            Element applyInClassElem = classElem;
            while (applyMethodElem == null && applyInClassElem != null) {
                for (Element element : applyInClassElem.getEnclosedElements()) {
                    if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().toString().startsWith("apply")) continue;
                    applyMethodElem = element;
                    break;
                }
                if (applyMethodElem != null) break;
                applyInClassElem = this.elementUtils.getTypeElement(((TypeElement)applyInClassElem).getSuperclass().toString());
            }
            if (applyMethodElem == null) {
                this.messenger.printMessage(Diagnostic.Kind.ERROR, "Unable to enumerate input and output types for " + simpleClassName);
                return false;
            }
            VariableElement inParam = ((ExecutableElement)applyMethodElem).getParameters().get(0);
            String string = inParam.asType().toString();
            String outType = ((ExecutableElement)applyMethodElem).getReturnType().toString();
            this.enumerator.onApplyTypes(string, outType);
            for (Element element : classElem.getEnclosedElements()) {
                Example[] exampleAnnotations;
                if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
                List<? extends VariableElement> parameters = ((ExecutableElement)element).getParameters();
                LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
                boolean isVarArgs = ((ExecutableElement)element).isVarArgs();
                for (int i = 0; i < parameters.size(); ++i) {
                    VariableElement var = parameters.get(i);
                    String varName = var.getSimpleName().toString();
                    String varType = var.asType().toString() + (i == parameters.size() - 1 ? (isVarArgs ? "..." : "") : "");
                    args.put(varName, varType);
                }
                String ctorDoc = this.elementUtils.getDocComment(element);
                ctorDoc = ctorDoc == null ? "" : this.cleanJavadoc(ctorDoc);
                ArrayList<List<String>> exampleData = new ArrayList<List<String>>();
                for (Example example : exampleAnnotations = (Example[])element.getAnnotationsByType(Example.class)) {
                    example.value();
                    exampleData.add(Arrays.asList(example.value()));
                }
                this.enumerator.onConstructor(args, ctorDoc, exampleData);
            }
            this.enumerator.flush();
        }
        if (roundEnv.processingOver()) {
            String classNames = this.classNameListener.getClassNames().stream().collect(Collectors.joining(","));
            this.messenger.printMessage(Diagnostic.Kind.NOTE, "found " + this.classNameListener.getClassNames().size() + " classes.");
            if (this.moduleElements.size() != 1) {
                this.messenger.printMessage(Diagnostic.Kind.ERROR, "Must have exactly one module in this annotation processor, found " + this.moduleElements.stream().map(ModuleElement::getQualifiedName).map(String::valueOf).collect(Collectors.joining(",")));
            }
            String moduleName = this.moduleElements.stream().findFirst().map(ModuleElement::getQualifiedName).map(String::valueOf).orElseThrow();
            String moduleList = this.functionNames.stream().collect(Collectors.joining("\n"));
            ProcessorFileUtils.writeGeneratedFileOrThrow(this.filer, "", FUNCTIONS_FILE, moduleList);
            this.moduleElements.clear();
            this.functionNames.clear();
        }
        return false;
    }

    private String inheritDocs(String classDoc, Element classElem) {
        if (classDoc == null) {
            return null;
        }
        Matcher matcher = inheritDocPattern.matcher(classDoc);
        if (!matcher.matches()) {
            return classDoc;
        }
        StringBuilder docData = new StringBuilder();
        String pre = matcher.group("pre");
        String post = matcher.group("post");
        Optional<TypeElement> inheritFromElement = Optional.ofNullable(((TypeElement)classElem).getSuperclass()).map(String::valueOf).map(this.elementUtils::getTypeElement);
        if (!inheritFromElement.isPresent()) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "Element " + classElem.toString() + " has '{@inheritDoc}', but a superclass was not found.");
            return pre + "UNABLE TO FIND ELEMENT TO INHERIT DOCS FROM for " + classElem.toString() + " " + post;
        }
        TypeElement inheritFromType = inheritFromElement.get();
        String inheritedDocs = this.elementUtils.getDocComment(inheritFromType);
        if (inheritedDocs == null) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "javadocs are missing on " + inheritFromElement.toString() + ", but " + classElem.toString() + " is trying to inherit docs from it.");
            return pre + "UNABLE TO FIND INHERITED DOCS for " + classElem.toString() + " " + post;
        }
        if (inheritDocPattern.matcher(inheritedDocs).matches()) {
            return pre + this.inheritDocs(inheritedDocs, inheritFromType) + post;
        }
        return pre + inheritedDocs + post;
    }

    private String cleanJavadoc(String ctorDoc) {
        return ctorDoc.replaceAll("(?m)^ ", "");
    }

    private static class StdoutListener
    implements FuncEnumerator.Listener {
        private StdoutListener() {
        }

        @Override
        public void onFunctionModel(DocForFunc functionDoc) {
            System.out.println(functionDoc);
        }
    }
}

