/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.services;

import io.virtdata.autodoctypes.DocFuncData;
import java.util.List;

public interface FunctionFinderService {
    public static final String FUNCTIONS_FILE = "FUNCTION-DATA/functions.txt";

    public List<Path> getFunctionPaths();

    public List<? extends DocFuncData> getFuncDataForModule();

    public static class Path {
        public final String moduleName;
        public final String className;
        public final FunctionFinderService finder;

        public Path(String moduleName, String className, FunctionFinderService finder) {
            this.moduleName = moduleName;
            this.className = className;
            this.finder = finder;
        }

        public DocFuncData instantiateDocs() {
            Class<DocFuncData> docFuncDataClass = Class.forName(this.finder.getClass().getModule(), this.className + "AutoDocsInfo").asSubclass(DocFuncData.class);
            DocFuncData docFuncData = null;
            try {
                docFuncData = docFuncDataClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while instantiating " + this.moduleName + "/" + this.className + ": " + e.getMessage(), e);
            }
            return docFuncData;
        }

        public String toString() {
            return this.moduleName + "/" + this.className;
        }
    }
}

