/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberList;
import java.util.List;

public final class FieldList
extends MemberList<FieldInfo> {
    private static final FieldList EMPTY = new FieldList(new FieldInfo[0]);

    public static FieldList empty() {
        return EMPTY;
    }

    public FieldList(List<? extends FieldInfo> elements) {
        super(FieldInfo.class, elements);
    }

    public FieldList(FieldInfo ... elements) {
        super(FieldInfo.class, (MemberInfo[])elements);
    }

    public FieldList(FieldInfo[] elements, int offset, int length) {
        super(FieldInfo.class, (MemberInfo[])elements, offset, length);
    }

    @Override
    @NotNull
    public FieldList subList(int fromIndex, int toIndex) {
        FieldList.subListRangeCheck(fromIndex, toIndex, this.size());
        int offset = this.getOffset() + fromIndex;
        int length = toIndex - fromIndex;
        if (length == 0) {
            return FieldList.empty();
        }
        return new FieldList((FieldInfo[])this.getElements(), offset, length);
    }
}

