/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.api.composers.ComposerForDoubleToIntFunction;
import io.virtdata.api.composers.ComposerForDoubleToLongFunction;
import io.virtdata.api.composers.ComposerForDoubleUnaryOperator;
import io.virtdata.api.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class ComposerForDoubleFunction
implements FunctionComposer<DoubleFunction<?>> {
    private final DoubleFunction<?> inner;

    public ComposerForDoubleFunction(DoubleFunction<?> inner) {
        this.inner = inner;
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }

    @Override
    public FunctionComposer andThen(Object outer) {
        FunctionType functionType = FunctionType.valueOf(outer);
        switch (functionType) {
            case long_long: {
                DoubleToLongFunction f1 = d -> ((LongUnaryOperator)outer).applyAsLong(((DoubleToLongFunction)((Object)this.inner)).applyAsLong(d));
                return new ComposerForDoubleToLongFunction(f1);
            }
            case long_T: {
                DoubleFunction<Object> f2 = d -> ((LongFunction)outer).apply((Long)this.inner.apply(d));
                return new ComposerForDoubleFunction(f2);
            }
            case long_int: {
                DoubleToIntFunction f3 = d -> ((LongToIntFunction)outer).applyAsInt((Long)this.inner.apply(d));
                return new ComposerForDoubleToIntFunction(f3);
            }
            case long_double: {
                DoubleUnaryOperator f4 = d -> ((LongToDoubleFunction)outer).applyAsDouble((Long)this.inner.apply(d));
                return new ComposerForDoubleUnaryOperator(f4);
            }
            case int_int: {
                DoubleToIntFunction f5 = d -> ((IntUnaryOperator)outer).applyAsInt((Integer)this.inner.apply(d));
                return new ComposerForDoubleToIntFunction(f5);
            }
            case int_long: {
                DoubleToLongFunction f6 = d -> ((IntToLongFunction)outer).applyAsLong((Integer)this.inner.apply(d));
                return new ComposerForDoubleToLongFunction(f6);
            }
            case int_double: {
                DoubleUnaryOperator f7 = d -> ((IntToDoubleFunction)outer).applyAsDouble((Integer)this.inner.apply(d));
                return new ComposerForDoubleUnaryOperator(f7);
            }
            case int_T: {
                DoubleFunction<Object> f8 = d -> ((IntFunction)outer).apply((Integer)this.inner.apply(d));
                return new ComposerForDoubleFunction(f8);
            }
            case double_double: {
                DoubleUnaryOperator f9 = d -> ((DoubleUnaryOperator)outer).applyAsDouble((Double)this.inner.apply(d));
                return new ComposerForDoubleUnaryOperator(f9);
            }
            case double_long: {
                DoubleToLongFunction f10 = d -> ((DoubleToLongFunction)outer).applyAsLong(((Long)this.inner.apply(d)).longValue());
                return new ComposerForDoubleToLongFunction(f10);
            }
            case double_int: {
                DoubleToIntFunction f11 = d -> ((DoubleToIntFunction)outer).applyAsInt(((Integer)this.inner.apply(d)).intValue());
                return new ComposerForDoubleToIntFunction(f11);
            }
            case double_T: {
                DoubleFunction<Object> f12 = d -> ((DoubleFunction)outer).apply((Double)this.inner.apply(d));
                return new ComposerForDoubleFunction(f12);
            }
        }
        throw new RuntimeException((Object)((Object)functionType) + " is not recognized");
    }
}

