/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.ReadOnlyList;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import java.util.Collection;
import java.util.List;

public final class ParameterList
extends ReadOnlyList<ParameterInfo> {
    private static final ParameterList EMPTY = new ParameterList(new ParameterInfo[0]);
    private TypeList _parameterTypes;

    public static ParameterList empty() {
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeList getParameterTypes() {
        if (this._parameterTypes == null) {
            ParameterList parameterList = this;
            synchronized (parameterList) {
                if (this._parameterTypes == null) {
                    Type[] types = new Type[this.size()];
                    int n = this.size();
                    for (int i = 0; i < n; ++i) {
                        types[i] = ((ParameterInfo)this.get(i)).getParameterType();
                    }
                    this._parameterTypes = new TypeList(types);
                }
            }
        }
        return this._parameterTypes;
    }

    public ParameterList(List<ParameterInfo> elements) {
        super(ParameterInfo.class, (Collection)VerifyArgument.noNullElements(elements, "elements"));
    }

    public ParameterList(ParameterInfo ... elements) {
        super(VerifyArgument.noNullElements(elements, "elements"));
    }

    public ParameterList(ParameterInfo[] elements, int offset, int length) {
        super((T[])VerifyArgument.noNullElements(elements, offset, length, "elements"), offset, length);
    }
}

