/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapper;
import io.virtdata.api.VirtDataFunctionLibrary;
import io.virtdata.core.ResolvedFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataLibraries
implements VirtDataFunctionLibrary {
    private static final Logger logger = LoggerFactory.getLogger(VirtDataLibraries.class);
    private static VirtDataLibraries instance = new VirtDataLibraries();
    private final Map<String, DataMapper<?>> threadSafeCache = new HashMap();
    private final Map<String, VirtDataFunctionLibrary> libraries = Finder.find();

    public static VirtDataLibraries get() {
        return instance;
    }

    private VirtDataLibraries() {
    }

    @Override
    public String getName() {
        return "ALL";
    }

    @Override
    public List<ResolvedFunction> resolveFunctions(Class<?> returnType, Class<?> inputType, String functionName, Object ... parameters) {
        ArrayList<ResolvedFunction> resolvedFunctions = new ArrayList<ResolvedFunction>();
        for (VirtDataFunctionLibrary library : this.libraries.values()) {
            List<ResolvedFunction> resolved = library.resolveFunctions(returnType, inputType, functionName, parameters);
            if (resolved.size() <= 0) continue;
            resolvedFunctions.addAll(resolved);
        }
        return resolvedFunctions;
    }

    @Override
    public List<String> getDataMapperNames() {
        return this.libraries.values().stream().flatMap(l -> l.getDataMapperNames().stream()).collect(Collectors.toList());
    }

    private static class Finder {
        private Finder() {
        }

        public static synchronized Map<String, VirtDataFunctionLibrary> find() {
            HashMap<String, VirtDataFunctionLibrary> libraries = new HashMap<String, VirtDataFunctionLibrary>();
            if (libraries.size() == 0) {
                logger.debug("loading DataMapper Libraries");
                ServiceLoader<VirtDataFunctionLibrary> sl = ServiceLoader.load(VirtDataFunctionLibrary.class);
                HashMap<String, Integer> dups = new HashMap<String, Integer>();
                for (VirtDataFunctionLibrary functionLibrary : sl) {
                    logger.debug("Found data mapper library:" + functionLibrary.getClass().getCanonicalName() + ":" + functionLibrary.getName());
                    if (libraries.get(functionLibrary.getName()) != null) {
                        String name = functionLibrary.getName();
                        dups.put(name, dups.getOrDefault(name, 0) + 1);
                    }
                    libraries.put(functionLibrary.getName(), functionLibrary);
                }
                if (dups.size() > 0) {
                    logger.debug("Java runtime provided duplicates for " + dups.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(",")));
                }
            }
            logger.info("Loaded DataMapper Libraries:" + libraries.keySet());
            return libraries;
        }
    }
}

