/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.Type;
import io.virtdata.api.FunctionType;
import io.virtdata.api.ValueType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;

public class ResolvedFunction {
    private final Class<?> inputType;
    private final Class<?> outputType;
    private Class<?>[] initializerSignature;
    private Object[] initializerValues;
    private FunctionType functionType;
    private Object functionObject;
    private String libraryName;
    private boolean isThreadSafe;
    public static Comparator<ResolvedFunction> PREFERRED_TYPE_COMPARATOR = new PreferredTypeComparator();

    public ResolvedFunction(Object g, boolean isThreadSafe, Class<?>[] initializerSignature, Object[] initValues, Class<?> inputType, Class<?> outputType, String libraryName) {
        this(g, isThreadSafe, initializerSignature, initValues, inputType, outputType);
        this.libraryName = libraryName;
    }

    public ResolvedFunction(Object g, boolean isThreadSafe, Class<?>[] initializerSignature, Object[] initValues, Class<?> inputType, Class<?> outputType) {
        this.functionObject = g;
        this.isThreadSafe = isThreadSafe;
        this.functionType = FunctionType.valueOf(g);
        this.initializerSignature = initializerSignature;
        this.initializerValues = initValues;
        this.inputType = inputType;
        this.outputType = outputType;
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public void setFunctionType(FunctionType functionType) {
        this.functionType = functionType;
    }

    public Object getFunctionObject() {
        return this.functionObject;
    }

    public void setFunctionObject(Object functionObject) {
        this.functionObject = functionObject;
    }

    public Class<?> getResultClass() {
        Method applyMethod = this.getMethod();
        Type<?> returnType = Type.of(this.functionObject.getClass()).getMethod(applyMethod.getName(), new Type[0]).getReturnType();
        return returnType.getErasedClass();
    }

    public Class<?> getInputClass() {
        Method applyMethod = this.getMethod();
        Type<?> inputType = ((ParameterInfo)Type.of(this.functionObject.getClass()).getMethod(applyMethod.getName(), new Type[0]).getParameters().get(0)).getParameterType();
        return inputType.getErasedClass();
    }

    public Class<?> getArgType() {
        Method applyMethod = this.getMethod();
        if (applyMethod.getParameterCount() != 1) {
            throw new RuntimeException("The parameter cound is supposed to be 1, but it was" + applyMethod.getParameterCount());
        }
        return applyMethod.getParameterTypes()[0];
    }

    private Method getMethod() {
        Optional<Method> foundMethod = Arrays.stream(this.functionObject.getClass().getMethods()).filter(m -> !m.isSynthetic() && !m.isBridge() && !m.isDefault()).filter(m -> m.getName().startsWith("apply")).findFirst();
        return foundMethod.orElseThrow(() -> new RuntimeException("Unable to find the function method on " + this.functionObject.getClass().getCanonicalName()));
    }

    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    public static String getStringLegend() {
        return "[<library name>::] input->class->output [initializer type->parameter type,...]";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.libraryName != null) {
            sb.append(this.libraryName).append("::");
        }
        sb.append(this.getArgType().getSimpleName()).append("->");
        sb.append(this.getMethod().getDeclaringClass().getName());
        sb.append("->").append(this.getResultClass().getName());
        if (this.initializerValues != null && this.initializerValues.length > 0) {
            sb.append(" [");
            for (int i = 0; i < this.initializerValues.length; ++i) {
                Class<?> init = this.initializerValues[i].getClass();
                sb.append(init.isPrimitive() ? init.getName() : init.getSimpleName());
                sb.append("=>");
                if (i < this.initializerSignature.length) {
                    Class<?> isig = this.initializerSignature[i];
                    sb.append(isig.isPrimitive() ? isig.getName() : isig.getSimpleName());
                } else {
                    sb.append("init-signature-mismatch");
                }
                if (i >= this.initializerValues.length - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private static class PreferredTypeComparator
    implements Comparator<ResolvedFunction> {
        private PreferredTypeComparator() {
        }

        @Override
        public int compare(ResolvedFunction o1, ResolvedFunction o2) {
            ValueType iv2;
            ValueType iv1 = ValueType.valueOfAssignableClass(o1.getArgType());
            int inputComparison = iv1.compareTo(iv2 = ValueType.valueOfAssignableClass(o2.getArgType()));
            if (inputComparison != 0) {
                return inputComparison;
            }
            iv1 = ValueType.valueOfAssignableClass(o1.getResultClass());
            iv2 = ValueType.valueOfAssignableClass(o2.getResultClass());
            return iv1.compareTo(iv2);
        }
    }
}

