/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api;

import io.virtdata.api.ValueType;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public enum FunctionType {
    long_long(LongUnaryOperator.class, Long.TYPE, Long.TYPE),
    long_int(LongToIntFunction.class, Long.TYPE, Integer.TYPE),
    long_double(LongToDoubleFunction.class, Long.TYPE, Double.TYPE),
    long_T(LongFunction.class, Long.TYPE, Object.class),
    int_int(IntUnaryOperator.class, Integer.TYPE, Integer.TYPE),
    int_long(IntToLongFunction.class, Integer.TYPE, Long.TYPE),
    int_double(IntToDoubleFunction.class, Integer.TYPE, Double.TYPE),
    int_T(IntFunction.class, Integer.TYPE, Object.class),
    double_T(DoubleFunction.class, Double.TYPE, Object.class),
    double_double(DoubleUnaryOperator.class, Double.TYPE, Double.TYPE),
    double_int(DoubleToIntFunction.class, Double.TYPE, Integer.TYPE),
    double_long(DoubleToLongFunction.class, Double.TYPE, Long.TYPE),
    R_T(Function.class, Object.class, Object.class);

    private final Class<?> functionClass;
    private Class<?> inputClass;
    private Class<?> returnClass;
    private ValueType returnValueType;
    private ValueType inputValueType;

    private FunctionType(Class<?> functionClass, Class<?> inputClass, Class<?> returnClass) {
        this.functionClass = functionClass;
        this.inputClass = inputClass;
        this.returnClass = returnClass;
        this.returnValueType = ValueType.valueOfAssignableClass(returnClass);
        this.inputValueType = ValueType.valueOfAssignableClass(inputClass);
    }

    public static FunctionType valueOf(Class<?> clazz) {
        for (FunctionType functionType : FunctionType.values()) {
            if (functionType.functionClass != clazz) continue;
            return functionType;
        }
        throw new RuntimeException("Unable to determine FunctionType for object class:" + clazz);
    }

    public static FunctionType valueOf(Object g) {
        for (FunctionType functionType : FunctionType.values()) {
            if (!functionType.functionClass.isAssignableFrom(g.getClass())) continue;
            return functionType;
        }
        throw new RuntimeException("Unable to determine FunctionType for object class:" + g.getClass());
    }

    public ValueType getReturnValueType() {
        return this.returnValueType;
    }

    public ValueType getInputValueType() {
        return this.inputValueType;
    }
}

