/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapper;
import io.virtdata.ast.VirtDataFlow;
import io.virtdata.core.BindingsTemplate;
import io.virtdata.core.CompatibilityFixups;
import io.virtdata.core.DataMapperFunctionMapper;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.core.VirtDataComposer;
import io.virtdata.parser.VirtDataDSL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class VirtData {
    public static BindingsTemplate getTemplate(String ... namesAndSpecs) {
        if (namesAndSpecs.length % 2 != 0) {
            throw new RuntimeException("args must be in 'name','spec', pairs. This can't be true for " + namesAndSpecs.length + "elements.");
        }
        HashMap<String, String> specmap = new HashMap<String, String>();
        for (int i = 0; i < namesAndSpecs.length; i += 2) {
            specmap.put(namesAndSpecs[i], namesAndSpecs[i + 1]);
        }
        return VirtData.getTemplate(specmap);
    }

    public static BindingsTemplate getTemplate(Map<String, String> namedBindings) {
        for (String bindingSpec : namedBindings.values()) {
            VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)bindingSpec);
            if (parseResult.throwable == null) continue;
            throw new RuntimeException(parseResult.throwable);
        }
        return new BindingsTemplate(namedBindings);
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String flowSpec) {
        flowSpec = CompatibilityFixups.fixup(flowSpec);
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)flowSpec);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow flow = parseResult.flow;
        VirtDataComposer composer = new VirtDataComposer();
        Optional<ResolvedFunction> resolvedFunction = composer.resolveFunctionFlow(flow);
        return resolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
    }

    public static <T> DataMapper<T> getMapper(String flowSpec) {
        Optional<DataMapper<T>> optionalMapper = VirtData.getOptionalMapper(flowSpec);
        return optionalMapper.orElseThrow(() -> new RuntimeException("Unable to find mapper: " + flowSpec));
    }

    public static <T> DataMapper<T> getMapper(String flowSpec, Class<? extends T> clazz) {
        Optional<DataMapper<T>> dataMapper = VirtData.getOptionalMapper(flowSpec);
        return dataMapper.orElseThrow(() -> new RuntimeException("Unable to find mapper: " + flowSpec));
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String flowSpec, Class<? extends T> clazz) {
        Optional<DataMapper<T>> dataMapper = VirtData.getOptionalMapper(flowSpec);
        return dataMapper;
    }
}

