/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api;

import io.virtdata.api.ThreadSafeMapper;
import io.virtdata.api.VirtDataFunctionLibrary;
import io.virtdata.core.ResolvedFunction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicFunctionalLibrary
implements VirtDataFunctionLibrary {
    private static final Logger logger = LoggerFactory.getLogger(BasicFunctionalLibrary.class);

    @Override
    public abstract String getName();

    public abstract List<Package> getSearchPackages();

    @Override
    public List<ResolvedFunction> resolveFunctions(Class<?> returnType, Class<?> inputType, String functionName, Object ... parameters) {
        ArrayList<ResolvedFunction> resolvedFunctions = new ArrayList<ResolvedFunction>();
        List matchingClasses = this.getSearchPackages().stream().map(p -> p.getName() + "." + functionName).map(this::maybeClassForName).filter(Objects::nonNull).collect(Collectors.toList());
        List matchingConstructors = matchingClasses.stream().filter(c -> {
            boolean isFunctional = this.isFunctionalInterface((Class<?>)c);
            boolean canAssignInput = inputType == null || this.canAssignInputType((Class<?>)c, inputType);
            boolean canAssignReturn = returnType == null || this.canAssignReturnType((Class<?>)c, returnType);
            boolean matchesSignature = isFunctional && canAssignInput && canAssignReturn;
            return matchesSignature;
        }).flatMap(c -> Arrays.stream(c.getDeclaredConstructors())).filter(c -> {
            boolean canAssignArgv = this.canAssignArguments((Constructor<?>)c, parameters);
            return canAssignArgv;
        }).collect(Collectors.toList());
        if (returnType != null && inputType != null && matchingConstructors.size() > 1) {
            throw new RuntimeException("found more than one (" + matchingConstructors.size() + ") matching constructor for return type '" + returnType + "', inputType '" + inputType + "', function name '" + functionName + ", and parameter types '" + Arrays.toString(parameters) + "', ctors: " + matchingConstructors);
        }
        for (Constructor ctor : matchingConstructors) {
            try {
                Object func = ctor.newInstance(parameters);
                boolean threadSafe = ctor.getClass().getAnnotation(ThreadSafeMapper.class) != null;
                resolvedFunctions.add(new ResolvedFunction(func, threadSafe, ctor.getParameterTypes(), parameters, this.getInputClass(ctor.getDeclaringClass()), this.getOutputClas(ctor.getDeclaringClass()), this.getName()));
            }
            catch (Exception e) {
                throw new RuntimeException("Error while calling constructor '" + ctor.toString() + "': " + e, e);
            }
        }
        return resolvedFunctions;
    }

    private boolean isFunctionalInterface(Class<?> c) {
        List applyMethods = Arrays.stream(c.getDeclaredMethods()).filter(m -> !m.isDefault() && !m.isBridge() && !m.isSynthetic()).filter(m -> (m.getModifiers() & 1) > 0).filter(m -> !m.getName().equals("toString")).collect(Collectors.toList());
        logger.trace("apply methods found for " + c.getCanonicalName() + ":" + applyMethods);
        int nonDefaultMethodCount = applyMethods.size();
        Optional<Method> applyMethod = Arrays.stream(c.getMethods()).filter(m -> !m.isDefault() && !m.isBridge() && !m.isSynthetic()).filter(m -> (m.getModifiers() & 1) > 0).filter(m -> m.getName().startsWith("apply")).findFirst();
        return nonDefaultMethodCount == 1 && applyMethod.isPresent();
    }

    private boolean canAssignArguments(Constructor<?> targetConstructor, Object[] sourceParameters) {
        Class<?>[] targetTypes = targetConstructor.getParameterTypes();
        if (sourceParameters.length != targetTypes.length) {
            logger.trace(targetConstructor.toString() + " does not match source parameters (size): " + Arrays.toString(sourceParameters));
            return false;
        }
        Class[] sourceTypes = new Class[sourceParameters.length];
        for (int i = 0; i < sourceTypes.length; ++i) {
            sourceTypes[i] = sourceParameters[i].getClass();
        }
        boolean isAssignable = ClassUtils.isAssignable(sourceTypes, targetTypes, true);
        return isAssignable;
    }

    private boolean canAssignReturnType(Class<?> functionalClass, Class<?> returnType) {
        Class<?> sourceType = this.toFunctionalMethod(functionalClass).getReturnType();
        boolean isAssignable = returnType.isAssignableFrom(sourceType);
        return isAssignable;
    }

    private Class<?> getInputClass(Class<?> functionalClass) {
        return this.toFunctionalMethod(functionalClass).getParameterTypes()[0];
    }

    private Class<?> getOutputClas(Class<?> functionClass) {
        return this.toFunctionalMethod(functionClass).getReturnType();
    }

    private boolean canAssignInputType(Class<?> functionalClass, Class<?> inputType) {
        boolean isAssignable = this.toFunctionalMethod(functionalClass).getParameterTypes()[0].isAssignableFrom(inputType);
        return isAssignable;
    }

    private Class<?> maybeClassForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Method toFunctionalMethod(Class<?> clazz) {
        Optional<Method> foundMethod = Arrays.stream(clazz.getMethods()).filter(m -> !m.isDefault() && !m.isBridge() && !m.isSynthetic()).filter(m -> m.getName().startsWith("apply")).findFirst();
        return foundMethod.orElseThrow(() -> new RuntimeException("Unable to find the function method on " + clazz.getCanonicalName()));
    }

    @Override
    public List<String> getDataMapperNames() {
        LinkedList<ClassLoader> classLoadersList = new LinkedList<ClassLoader>();
        classLoadersList.add(ClasspathHelper.contextClassLoader());
        classLoadersList.add(ClasspathHelper.staticClassLoader());
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setScanners(new SubTypesScanner(false), new ResourcesScanner());
        cb.setUrls(ClasspathHelper.forClassLoader(classLoadersList.toArray(new ClassLoader[0])));
        FilterBuilder fb = new FilterBuilder();
        for (Package aPackage : this.getSearchPackages()) {
            fb.include(FilterBuilder.prefix(aPackage.getName()));
        }
        cb.filterInputsBy(fb);
        Reflections reflections = new Reflections(cb);
        Set<Class<Object>> subTypesOf = reflections.getSubTypesOf(Object.class);
        ArrayList collected = subTypesOf.stream().map(Class::getSimpleName).collect(Collectors.toCollection(ArrayList::new));
        return collected;
    }

    public String toString() {
        return this.getName();
    }
}

