/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapperLibrary;
import io.virtdata.api.ValueType;
import io.virtdata.api.VirtDataFunctionLibrary;
import io.virtdata.api.composers.FunctionAssembly;
import io.virtdata.ast.Expression;
import io.virtdata.ast.FunctionCall;
import io.virtdata.ast.VirtDataFlow;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.core.ResolverDiagnostics;
import io.virtdata.core.VirtDataLibraries;
import io.virtdata.parser.VirtDataDSL;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataComposer {
    private static final String PREAMBLE = "compose ";
    private static final Logger logger = LoggerFactory.getLogger(DataMapperLibrary.class);
    private final VirtDataFunctionLibrary functionLibrary;
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();

    public VirtDataComposer(VirtDataFunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public VirtDataComposer() {
        this.functionLibrary = VirtDataLibraries.get();
    }

    public Optional<ResolvedFunction> resolveFunctionFlow(String flowspec) {
        String strictSpec = flowspec.startsWith(PREAMBLE) ? flowspec.substring(8) : flowspec;
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)strictSpec);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow flow = parseResult.flow;
        return this.resolveFunctionFlow(flow);
    }

    public ResolverDiagnostics resolveDiagnosticFunctionFlow(String flowspec) {
        String strictSpec = flowspec.startsWith(PREAMBLE) ? flowspec.substring(8) : flowspec;
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)strictSpec);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow flow = parseResult.flow;
        return this.resolveDiagnosticFunctionFlow(flow);
    }

    public ResolverDiagnostics resolveDiagnosticFunctionFlow(VirtDataFlow flow) {
        ResolverDiagnostics diagnostics = new ResolverDiagnostics();
        diagnostics.trace("processing flow " + flow.toString() + " from output to input");
        LinkedList<List<ResolvedFunction>> funcs = new LinkedList<List<ResolvedFunction>>();
        LinkedList<Set<Object>> nextFunctionInputTypes = new LinkedList<Set<Object>>();
        Optional<Class> finalValueTypeOption = Optional.ofNullable(flow.getLastExpression().getCall().getOutputType()).map(ValueType::valueOfClassName).map(ValueType::getValueClass);
        nextFunctionInputTypes.add(new HashSet());
        finalValueTypeOption.ifPresent(t -> ((Set)nextFunctionInputTypes.get(0)).add(t));
        diagnostics.trace("working backwards from " + (flow.getExpressions().size() - 1));
        for (int i = flow.getExpressions().size() - 1; i >= 0; --i) {
            FunctionCall call = ((Expression)flow.getExpressions().get(i)).getCall();
            diagnostics.trace("resolving args for " + call.toString());
            LinkedList<ResolvedFunction> nodeFunctions = new LinkedList<ResolvedFunction>();
            String funcName = call.getFunctionName();
            Class<?> inputType = ValueType.classOfType(call.getInputType());
            Class<?> outputType = ValueType.classOfType(call.getOutputType());
            Object[] args = call.getArguments();
            try {
                args = this.populateFunctions(diagnostics, args);
            }
            catch (Exception e) {
                return diagnostics.error(e);
            }
            diagnostics.trace("resolved args: ");
            for (Object arg : args) {
                diagnostics.trace(" " + arg.getClass().getSimpleName() + ": " + arg.toString());
            }
            List<ResolvedFunction> resolved = this.functionLibrary.resolveFunctions(outputType, inputType, funcName, args);
            if (resolved.size() == 0) {
                return diagnostics.error(new RuntimeException("Unable to find even one function for " + call));
            }
            diagnostics.trace(" resolved functions:");
            diagnostics.trace(this.summarize(resolved));
            nodeFunctions.addAll(resolved);
            funcs.addFirst(nodeFunctions);
            Set inputTypes = nodeFunctions.stream().map(ResolvedFunction::getInputClass).collect(Collectors.toSet());
            nextFunctionInputTypes.addFirst(inputTypes);
        }
        if (!((Set)nextFunctionInputTypes.peekFirst()).contains(Long.TYPE)) {
            return diagnostics.error(new RuntimeException("There is no initial function which accepts a long input. Function chain, after type filtering: \n" + this.summarizeBulk(funcs)));
        }
        this.removeNonLongFunctions((List)funcs.getFirst());
        List<ResolvedFunction> flattenedFuncs = this.optimizePath(funcs, ValueType.classOfType(flow.getLastExpression().getCall().getOutputType()));
        if (flattenedFuncs.size() == 1) {
            diagnostics.trace("FUNCTION resolution succeeded (single): '" + flow.toString() + "'");
            return diagnostics.setResolvedFunction(flattenedFuncs.get(0));
        }
        FunctionAssembly assembly = new FunctionAssembly();
        diagnostics.trace("composed summary: " + this.summarize(flattenedFuncs));
        boolean isThreadSafe = true;
        diagnostics.trace("FUNCTION chain selected: (multi) '" + this.summarize(flattenedFuncs) + "'");
        for (ResolvedFunction resolvedFunction : flattenedFuncs) {
            try {
                Object functionObject = resolvedFunction.getFunctionObject();
                assembly.andThen(functionObject);
                if (resolvedFunction.isThreadSafe()) continue;
                isThreadSafe = false;
            }
            catch (Exception e) {
                return diagnostics.error(new RuntimeException("FUNCTION resolution failed: '" + flow.toString() + "': " + e.toString()));
            }
        }
        ResolvedFunction composedFunction = assembly.getResolvedFunction(isThreadSafe);
        diagnostics.trace("FUNCTION resolution succeeded (lambda): '" + flow.toString() + "'");
        return diagnostics.setResolvedFunction(composedFunction);
    }

    public Optional<ResolvedFunction> resolveFunctionFlow(VirtDataFlow flow) {
        ResolverDiagnostics resolverDiagnostics = this.resolveDiagnosticFunctionFlow(flow);
        return resolverDiagnostics.getResolvedFunction();
    }

    private Object[] populateFunctions(ResolverDiagnostics diagnostics, Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object o = args[i];
            if (!(o instanceof FunctionCall)) continue;
            FunctionCall call = (FunctionCall)o;
            String funcName = call.getFunctionName();
            Class<?> inputType = ValueType.classOfType(call.getInputType());
            Class<?> outputType = ValueType.classOfType(call.getOutputType());
            Object[] fargs = call.getArguments();
            diagnostics.trace("resolving argument as function '" + call.toString() + "'");
            fargs = this.populateFunctions(diagnostics, fargs);
            List<ResolvedFunction> resolved = this.functionLibrary.resolveFunctions(outputType, inputType, funcName, fargs);
            if (resolved.size() == 0) {
                throw new RuntimeException("Unable to resolve even one function for argument: " + call);
            }
            args[i] = resolved.get(0).getFunctionObject();
        }
        return args;
    }

    private void removeNonLongFunctions(List<ResolvedFunction> funcs) {
        LinkedList<ResolvedFunction> toRemove = new LinkedList<ResolvedFunction>();
        for (ResolvedFunction func : funcs) {
            if (func.getInputClass().isAssignableFrom(Long.TYPE)) continue;
            logger.trace("input type " + func.getInputClass().getCanonicalName() + " is not assignable from long");
            toRemove.add(func);
        }
        if (toRemove.size() > 0 && toRemove.size() == funcs.size()) {
            throw new RuntimeException("removeNonLongFunctions would remove all functions: " + funcs);
        }
        funcs.removeAll(toRemove);
    }

    private String summarize(List<ResolvedFunction> funcs) {
        return funcs.stream().map(String::valueOf).collect(Collectors.joining("|"));
    }

    private String summarizeBulk(List<List<ResolvedFunction>> funcs) {
        LinkedList spans = new LinkedList();
        funcs.forEach(l -> spans.add(l.stream().map(String::valueOf).collect(Collectors.toList())));
        List widths = spans.stream().map(l -> l.stream().map(String::length).max(Integer::compare)).collect(Collectors.toList());
        String funcsdata = spans.stream().map(l -> l.stream().map(String::valueOf).collect(Collectors.joining("|\n"))).collect(Collectors.joining("\n\n"));
        StringBuilder sb = new StringBuilder();
        sb.append("---\\\\\n").append(funcsdata).append("\n---////\n");
        return sb.toString();
    }

    private List<ResolvedFunction> optimizePath(List<List<ResolvedFunction>> funcs, Class<?> type) {
        List<ResolvedFunction> prevFuncs = null;
        List<ResolvedFunction> nextFuncs = null;
        int progress = -1;
        int pass = 0;
        while (progress != 0) {
            ++pass;
            progress = 0;
            progress += this.reduceByRequiredResultsType(funcs.get(funcs.size() - 1), type);
            if (funcs.size() > 1) {
                int stage = 0;
                for (List<ResolvedFunction> funcList : funcs) {
                    ++stage;
                    nextFuncs = funcList;
                    if (prevFuncs != null && nextFuncs != null && progress == 0 && (progress += this.reduceByDirectTypes(prevFuncs, nextFuncs)) == 0 && (progress += this.reduceByAssignableTypes(prevFuncs, nextFuncs, false)) == 0 && (progress += this.reduceByAssignableTypes(prevFuncs, nextFuncs, true)) == 0) {
                        progress += this.reduceByPreferredTypes(prevFuncs, nextFuncs);
                    }
                    prevFuncs = nextFuncs;
                }
                nextFuncs = null;
                prevFuncs = null;
                continue;
            }
            progress += this.reduceByPreferredResultTypes(funcs.get(0));
        }
        List<ResolvedFunction> optimized = funcs.stream().map(l -> (ResolvedFunction)l.get(0)).collect(Collectors.toList());
        return optimized;
    }

    private int reduceByRequiredResultsType(List<ResolvedFunction> endFuncs, Class<?> resultType) {
        int progressed = 0;
        LinkedList<ResolvedFunction> tmpList = new LinkedList<ResolvedFunction>(endFuncs);
        for (ResolvedFunction endFunc : tmpList) {
            if (resultType == null || ClassUtils.isAssignable(endFunc.getResultClass(), resultType, (boolean)true)) continue;
            endFuncs.remove(endFunc);
            String logmsg = "BY-REQUIRED-RESULT-TYPE removed function '" + endFunc + "' because is not assignable to " + resultType;
            logger.trace(logmsg);
            ++progressed;
        }
        if (endFuncs.size() == 0) {
            throw new RuntimeException("BY-REQUIRED-RESULT-TYPE No end funcs were found which are assignable to " + resultType);
        }
        return progressed;
    }

    private int reduceByPreferredResultTypes(List<ResolvedFunction> funcs) {
        int progressed = 0;
        if (funcs.size() > 1) {
            progressed += funcs.size() - 1;
            funcs.sort(ResolvedFunction.PREFERRED_TYPE_COMPARATOR);
            while (funcs.size() > 1) {
                logger.trace("BY-SINGLE-PREFERRED-TYPE removing func " + funcs.get(funcs.size() - 1) + " because " + funcs.get(0) + " has more preferred types.");
                funcs.remove(funcs.size() - 1);
            }
        }
        return progressed;
    }

    private int reduceByPreferredTypes(List<ResolvedFunction> prevFuncs, List<ResolvedFunction> nextFuncs) {
        int progressed;
        block3: {
            block2: {
                progressed = 0;
                if (prevFuncs.size() <= 1) break block2;
                progressed += prevFuncs.size() - 1;
                prevFuncs.sort(ResolvedFunction.PREFERRED_TYPE_COMPARATOR);
                while (prevFuncs.size() > 1) {
                    String logmsg = "BY-PREV-PREFERRED-TYPE removing func " + prevFuncs.get(prevFuncs.size() - 1) + " because " + prevFuncs.get(0) + " has more preferred types.";
                    logger.trace(logmsg);
                    prevFuncs.remove(prevFuncs.size() - 1);
                }
                break block3;
            }
            if (nextFuncs.size() <= 1) break block3;
            progressed += nextFuncs.size() - 1;
            nextFuncs.sort(ResolvedFunction.PREFERRED_TYPE_COMPARATOR);
            while (nextFuncs.size() > 1) {
                String logmsg = "BY-NEXT-PREFERRED-TYPE removing func " + nextFuncs.get(nextFuncs.size() - 1) + " because " + nextFuncs.get(0) + " has more preferred types.";
                logger.trace(logmsg);
                nextFuncs.remove(nextFuncs.size() - 1);
            }
        }
        return progressed;
    }

    private int reduceByDirectTypes(List<ResolvedFunction> prevFuncs, List<ResolvedFunction> nextFuncs) {
        int progressed = 0;
        Set<Class<?>> outputs = this.getOutputs(prevFuncs);
        Set<Class<?>> inputs = this.getInputs(nextFuncs);
        Set directMatches = inputs.stream().filter(outputs::contains).collect(Collectors.toCollection(HashSet::new));
        if (directMatches.size() > 0) {
            ArrayList<ResolvedFunction> toremove = new ArrayList<ResolvedFunction>();
            for (ResolvedFunction nextFunc : nextFuncs) {
                if (directMatches.contains(nextFunc.getArgType())) continue;
                String logmsg = "BY-DIRECT-TYPE removing next func: " + nextFunc + " because its input types are not satisfied by any previous func";
                logger.trace(logmsg);
                toremove.add(nextFunc);
                ++progressed;
            }
            nextFuncs.removeAll(toremove);
        }
        return progressed;
    }

    private int reduceByAssignableTypes(List<ResolvedFunction> prevFuncs, List<ResolvedFunction> nextFuncs, boolean autoboxing) {
        Set<Class<?>> outputs = this.getOutputs(prevFuncs);
        Set<Class<?>> inputs = this.getInputs(nextFuncs);
        HashSet compatibleInputs = new HashSet();
        for (Class<?> clazz : inputs) {
            for (Class<?> output : outputs) {
                if (!ClassUtils.isAssignable(output, clazz, (boolean)autoboxing)) continue;
                compatibleInputs.add(clazz);
            }
        }
        ArrayList<ResolvedFunction> toremove = new ArrayList<ResolvedFunction>();
        for (ResolvedFunction nextfunc2 : nextFuncs) {
            if (compatibleInputs.contains(nextfunc2.getInputClass())) continue;
            toremove.add(nextfunc2);
        }
        if (toremove.size() == nextFuncs.size()) {
            String string = "BY-ASSIGNABLE-TYPE Not removing remaining " + nextFuncs.size() + " next funcs " + (autoboxing ? "with autoboxing " : "") + "because no functions would be left.";
            logger.trace(string);
            return 0;
        }
        toremove.forEach(nextfunc -> {
            String logmsg = "BY-ASSIGNABLE-TYPE removing next func: " + nextfunc + " because its input types are not assignable from any of the previous funcs";
            logger.trace(logmsg);
        });
        nextFuncs.removeAll(toremove);
        return toremove.size();
    }

    private Set<Class<?>> getOutputs(List<ResolvedFunction> prevFuncs) {
        HashSet outputs = new HashSet();
        for (ResolvedFunction func : prevFuncs) {
            outputs.add(func.getResultClass());
        }
        return outputs;
    }

    private Set<Class<?>> getInputs(List<ResolvedFunction> nextFuncs) {
        HashSet inputs = new HashSet();
        for (ResolvedFunction nextFunc : nextFuncs) {
            inputs.add(nextFunc.getArgType());
        }
        return inputs;
    }
}

