/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataResources {
    public static final String DATA_DIR = "data";
    private static final Logger logger = LoggerFactory.getLogger(VirtDataResources.class);

    public static CharBuffer readDataFileToCharBuffer(String basename) {
        return VirtDataResources.loadFileToCharBuffer(basename, DATA_DIR);
    }

    public static List<String> readDataFileLines(String basename) {
        return VirtDataResources.readFileLines(basename, DATA_DIR);
    }

    public static String readDataFileString(String basename) {
        return VirtDataResources.readFileString(basename, DATA_DIR);
    }

    public static InputStream findRequiredStreamOrFile(String basename, String extension, String ... searchPaths) {
        Optional<InputStream> optionalStreamOrFile = VirtDataResources.findOptionalStreamOrFile(basename, extension, searchPaths);
        return optionalStreamOrFile.orElseThrow(() -> new RuntimeException("Unable to find " + basename + " with extension " + extension + " in file system or in classpath, with search paths: " + Arrays.stream(searchPaths).collect(Collectors.joining(","))));
    }

    public static Reader findRequiredReader(String basename, String extension, String ... searchPaths) {
        Optional<Reader> optionalReader = VirtDataResources.findOptionalReader(basename, extension, searchPaths);
        return optionalReader.orElseThrow(() -> new RuntimeException("Unable to find " + basename + " with extension " + extension + " in file system or in classpath, with search paths: " + Arrays.stream(searchPaths).collect(Collectors.joining(","))));
    }

    public static Optional<Reader> findOptionalReader(String basename, String extenion, String ... searchPaths) {
        return VirtDataResources.findOptionalStreamOrFile(basename, extenion, searchPaths).map(InputStreamReader::new).map(BufferedReader::new);
    }

    public static Optional<Path> findOptionalDirPath(String pathName) {
        URL systemResource = ClassLoader.getSystemResource(pathName);
        if (systemResource != null) {
            try {
                return Optional.of(Path.of(systemResource.toURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    public static Optional<InputStream> findOptionalStreamOrFile(final String basename, String extension, final String ... searchPaths) {
        boolean needsExtension = extension != null && !extension.isEmpty() && !basename.endsWith("." + extension);
        final String filename = basename + (String)(needsExtension ? "." + extension : "");
        ArrayList<String> paths = new ArrayList<String>(){
            {
                this.add(filename);
                if (!VirtDataResources.isRemote(basename)) {
                    this.addAll(Arrays.stream(searchPaths).map(s -> s + File.separator + filename).collect(Collectors.toCollection(ArrayList::new)));
                }
            }
        };
        for (String path : paths) {
            Optional<InputStream> stream = VirtDataResources.getInputStream(path);
            if (!stream.isPresent()) continue;
            return stream;
        }
        return Optional.empty();
    }

    private static boolean isRemote(String path) {
        return path.toLowerCase().startsWith("http:") || path.toLowerCase().startsWith("https:");
    }

    public static Optional<InputStream> getInputStream(String path) {
        Optional<InputStream> inputStream;
        if (VirtDataResources.isRemote(path) && (inputStream = VirtDataResources.getInputStreamForUrl(path)) != null) {
            return inputStream;
        }
        try {
            FileInputStream stream = new FileInputStream(path);
            return Optional.of(stream);
        }
        catch (FileNotFoundException stream) {
            ClassLoader classLoader = VirtDataResources.class.getClassLoader();
            InputStream stream2 = classLoader.getResourceAsStream(path);
            if (stream2 != null) {
                return Optional.of(stream2);
            }
            return Optional.empty();
        }
    }

    public static Optional<InputStream> getInputStreamForUrl(String path) {
        try {
            URL url = new URL(path);
            InputStream inputStream = url.openStream();
            if (inputStream != null) {
                return Optional.of(inputStream);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static List<String> readFileLines(String basename, String ... searchPaths) {
        List<String> list;
        InputStream requiredStreamOrFile = VirtDataResources.findRequiredStreamOrFile(basename, "", DATA_DIR);
        BufferedReader buffer = new BufferedReader(new InputStreamReader(requiredStreamOrFile));
        try {
            List<String> collected;
            list = collected = buffer.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error while reading required file to string", ioe);
            }
        }
        buffer.close();
        return list;
    }

    public static String readFileString(String basename, String ... searchPaths) {
        String string;
        InputStream requiredStreamOrFile = VirtDataResources.findRequiredStreamOrFile(basename, "", searchPaths);
        BufferedReader buffer = new BufferedReader(new InputStreamReader(requiredStreamOrFile));
        try {
            String filedata;
            string = filedata = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error while reading required file to string", ioe);
            }
        }
        buffer.close();
        return string;
    }

    public static CSVParser readFileCSV(String basename, String ... searchPaths) {
        Reader reader = VirtDataResources.findRequiredReader(basename, "csv", searchPaths);
        CSVFormat format = CSVFormat.newFormat((char)',').withFirstRecordAsHeader();
        try {
            CSVParser parser = new CSVParser(reader, format);
            return parser;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CharBuffer loadFileToCharBuffer(String filename, String ... searchPaths) {
        CharBuffer linesImage;
        InputStream stream = VirtDataResources.findRequiredStreamOrFile(filename, "", searchPaths);
        try {
            InputStreamReader isr = new InputStreamReader(stream);
            linesImage = CharBuffer.allocate(0x100000);
            while (isr.read(linesImage) > 0) {
            }
            isr.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        linesImage.flip();
        return linesImage.asReadOnlyBuffer();
    }

    public static Path findPathIn(String ... pathspecs) {
        for (String pathspec : pathspecs) {
            Path foundPath = null;
            if (VirtDataResources.isRemote(pathspec)) {
                try {
                    Optional<InputStream> inputStreamForUrl = VirtDataResources.getInputStreamForUrl(pathspec);
                    if (inputStreamForUrl.isPresent()) {
                        foundPath = Path.of(URI.create(pathspec));
                        logger.debug("Found accessible remote file at " + foundPath.toString());
                    }
                }
                catch (Exception inputStreamForUrl) {}
            } else {
                boolean wantsADirectory = pathspec.endsWith(FileSystems.getDefault().getSeparator());
                String candidatePath = wantsADirectory ? pathspec.substring(0, pathspec.length() - 1) : pathspec;
                Path candidate = Path.of(candidatePath, new String[0]);
                try {
                    FileSystemProvider provider = candidate.getFileSystem().provider();
                    provider.checkAccess(candidate, AccessMode.READ);
                    BasicFileAttributes attrs = provider.readAttributes(candidate, BasicFileAttributes.class, new LinkOption[0]);
                    boolean foundADirectory = attrs.isDirectory();
                    if (wantsADirectory != foundADirectory) {
                        throw new RuntimeException("for path " + pathspec + ", user wanted a " + (wantsADirectory ? "directory" : "file") + ", but found a " + (foundADirectory ? "directory" : "file") + " while searching paths " + Arrays.toString(pathspecs));
                    }
                    foundPath = candidate;
                }
                catch (Exception provider) {
                    // empty catch block
                }
                if (foundPath == null) {
                    try {
                        ClassLoader cl = VirtDataResources.class.getClassLoader();
                        URL url = ClassLoader.getSystemResource(candidatePath);
                        if (url != null) {
                            URI uri = URI.create(url.toExternalForm());
                            foundPath = VirtDataResources.getPathInFilesystem(uri);
                            logger.debug("Found path in classpath: " + candidatePath + ": " + foundPath.toString());
                        }
                    }
                    catch (Exception e) {
                        logger.trace("Error while looking in classpath for " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (foundPath == null) continue;
            return foundPath;
        }
        throw new RuntimeException("Unable to find path in " + Arrays.toString(pathspecs));
    }

    private static synchronized Path getPathInFilesystem(URI uri) {
        FileSystem fileSystem = null;
        try {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException ignored) {
            try {
                fileSystem = FileSystems.newFileSystem(uri, Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Path.of(uri);
    }
}

