/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.Binder;
import io.virtdata.api.ValuesBinder;
import io.virtdata.core.Bindings;

public class ContextualBindings<C, R>
implements Binder<R> {
    private final C context;
    private Bindings bindings;
    private ValuesBinder<C, R> valuesBinder;

    public ContextualBindings(Bindings bindings, C c, ValuesBinder<C, R> valuesBinder) {
        this.bindings = bindings;
        this.context = c;
        this.valuesBinder = valuesBinder;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public C getContext() {
        return this.context;
    }

    @Override
    public R bind(long l) {
        Object[] objectArray = this.bindings.getAll(l);
        try {
            return this.valuesBinder.bindValues(this.context, this.bindings, l);
        }
        catch (Exception exception) {
            throw new RuntimeException("Binding error:" + this.bindings.getTemplate().toString(objectArray), exception);
        }
    }
}

