/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapperLibrary;
import io.virtdata.api.ValueType;
import io.virtdata.api.VirtDataFunctionLibrary;
import io.virtdata.api.composers.FunctionAssembly;
import io.virtdata.ast.Expression;
import io.virtdata.ast.FunctionCall;
import io.virtdata.ast.VirtDataFlow;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.core.ResolverDiagnostics;
import io.virtdata.core.VirtDataLibraries;
import io.virtdata.parser.VirtDataDSL;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataComposer {
    private static final String PREAMBLE = "compose ";
    private static final Logger logger = LoggerFactory.getLogger(DataMapperLibrary.class);
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private final VirtDataFunctionLibrary functionLibrary;
    private final Map<String, Object> customElements = new HashMap<String, Object>();

    public VirtDataComposer(VirtDataFunctionLibrary virtDataFunctionLibrary) {
        this.functionLibrary = virtDataFunctionLibrary;
    }

    public VirtDataComposer() {
        this.functionLibrary = VirtDataLibraries.get();
    }

    public Optional<ResolvedFunction> resolveFunctionFlow(String string) {
        String string2 = string.startsWith(PREAMBLE) ? string.substring(8) : string;
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)string2);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow virtDataFlow = parseResult.flow;
        return this.resolveFunctionFlow(virtDataFlow);
    }

    public ResolverDiagnostics resolveDiagnosticFunctionFlow(String string) {
        String string2 = string.startsWith(PREAMBLE) ? string.substring(8) : string;
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)string2);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow virtDataFlow = parseResult.flow;
        return this.resolveDiagnosticFunctionFlow(virtDataFlow);
    }

    public ResolverDiagnostics resolveDiagnosticFunctionFlow(VirtDataFlow virtDataFlow) {
        Object object;
        Object object2;
        Object object3;
        ResolverDiagnostics resolverDiagnostics = new ResolverDiagnostics();
        resolverDiagnostics.trace("processing flow " + virtDataFlow.toString() + " from output to input");
        LinkedList<List<ResolvedFunction>> linkedList = new LinkedList<List<ResolvedFunction>>();
        LinkedList<Set<Object>> linkedList2 = new LinkedList<Set<Object>>();
        Optional<Class> optional = Optional.ofNullable(virtDataFlow.getLastExpression().getCall().getOutputType()).map(ValueType::valueOfClassName).map(ValueType::getValueClass);
        linkedList2.add(new HashSet());
        optional.ifPresent(clazz -> ((Set)linkedList2.get(0)).add(clazz));
        resolverDiagnostics.trace("working backwards from " + (virtDataFlow.getExpressions().size() - 1));
        for (int i = virtDataFlow.getExpressions().size() - 1; i >= 0; --i) {
            object3 = ((Expression)virtDataFlow.getExpressions().get(i)).getCall();
            resolverDiagnostics.trace("resolving args for " + object3.toString());
            LinkedList linkedList3 = new LinkedList();
            object2 = object3.getFunctionName();
            Class<?> object4 = ValueType.classOfType(object3.getInputType());
            object = ValueType.classOfType(object3.getOutputType());
            Object[] objectArray = object3.getArguments();
            try {
                objectArray = this.populateFunctions(resolverDiagnostics, objectArray, this.customElements);
            }
            catch (Exception exception) {
                return resolverDiagnostics.error(exception);
            }
            resolverDiagnostics.trace("resolved args: ");
            for (Object object5 : objectArray) {
                resolverDiagnostics.trace(" " + object5.getClass().getSimpleName() + ": " + object5.toString());
            }
            List<ResolvedFunction> list = this.functionLibrary.resolveFunctions((Class<?>)object, object4, (String)object2, this.customElements, objectArray);
            if (list.size() == 0) {
                return resolverDiagnostics.error(new RuntimeException("Unable to find even one function for " + (FunctionCall)object3));
            }
            resolverDiagnostics.trace(" resolved functions:");
            resolverDiagnostics.trace(this.summarize(list));
            linkedList3.addAll(list);
            linkedList.addFirst(linkedList3);
            Set set = linkedList3.stream().map(ResolvedFunction::getInputClass).collect(Collectors.toSet());
            linkedList2.addFirst(set);
        }
        if (!((Set)linkedList2.peekFirst()).contains(Long.TYPE)) {
            return resolverDiagnostics.error(new RuntimeException("There is no initial function which accepts a long input. Function chain, after type filtering: \n" + this.summarizeBulk(linkedList)));
        }
        this.removeNonLongFunctions((List)linkedList.getFirst());
        List<ResolvedFunction> list = this.optimizePath(linkedList, ValueType.classOfType(virtDataFlow.getLastExpression().getCall().getOutputType()));
        if (list.size() == 1) {
            resolverDiagnostics.trace("FUNCTION resolution succeeded (single): '" + virtDataFlow.toString() + "'");
            return resolverDiagnostics.setResolvedFunction(list.get(0));
        }
        object3 = new FunctionAssembly();
        resolverDiagnostics.trace("composed summary: " + this.summarize(list));
        boolean bl = true;
        resolverDiagnostics.trace("FUNCTION chain selected: (multi) '" + this.summarize(list) + "'");
        for (ResolvedFunction resolvedFunction : list) {
            try {
                object = resolvedFunction.getFunctionObject();
                ((FunctionAssembly)object3).andThen(object);
                if (resolvedFunction.isThreadSafe()) continue;
                bl = false;
            }
            catch (Exception exception) {
                return resolverDiagnostics.error(new RuntimeException("FUNCTION resolution failed: '" + virtDataFlow.toString() + "': " + exception.toString()));
            }
        }
        object2 = object3.getResolvedFunction(bl);
        resolverDiagnostics.trace("FUNCTION resolution succeeded (lambda): '" + virtDataFlow.toString() + "'");
        return resolverDiagnostics.setResolvedFunction((ResolvedFunction)object2);
    }

    public Optional<ResolvedFunction> resolveFunctionFlow(VirtDataFlow virtDataFlow) {
        ResolverDiagnostics resolverDiagnostics = this.resolveDiagnosticFunctionFlow(virtDataFlow);
        return resolverDiagnostics.getResolvedFunction();
    }

    private Object[] populateFunctions(ResolverDiagnostics resolverDiagnostics, Object[] objectArray, Map<String, ?> map) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof FunctionCall)) continue;
            FunctionCall functionCall = (FunctionCall)object;
            String string = functionCall.getFunctionName();
            Class<?> clazz = ValueType.classOfType(functionCall.getInputType());
            Class<?> clazz2 = ValueType.classOfType(functionCall.getOutputType());
            Object[] objectArray2 = functionCall.getArguments();
            resolverDiagnostics.trace("resolving argument as function '" + functionCall.toString() + "'");
            objectArray2 = this.populateFunctions(resolverDiagnostics, objectArray2, map);
            List<ResolvedFunction> list = this.functionLibrary.resolveFunctions(clazz2, clazz, string, map, objectArray2);
            if (list.size() == 0) {
                throw new RuntimeException("Unable to resolve even one function for argument: " + functionCall);
            }
            objectArray[i] = list.get(0).getFunctionObject();
        }
        return objectArray;
    }

    private void removeNonLongFunctions(List<ResolvedFunction> list) {
        LinkedList<ResolvedFunction> linkedList = new LinkedList<ResolvedFunction>();
        for (ResolvedFunction resolvedFunction : list) {
            if (resolvedFunction.getInputClass().isAssignableFrom(Long.TYPE)) continue;
            logger.trace("input type " + resolvedFunction.getInputClass().getCanonicalName() + " is not assignable from long");
            linkedList.add(resolvedFunction);
        }
        if (linkedList.size() > 0 && linkedList.size() == list.size()) {
            throw new RuntimeException("removeNonLongFunctions would remove all functions: " + list);
        }
        list.removeAll(linkedList);
    }

    private String summarize(List<ResolvedFunction> list) {
        return list.stream().map(String::valueOf).collect(Collectors.joining("|"));
    }

    private String summarizeBulk(List<List<ResolvedFunction>> list3) {
        LinkedList linkedList = new LinkedList();
        list3.forEach(list2 -> linkedList.add(list2.stream().map(String::valueOf).collect(Collectors.toList())));
        List list4 = linkedList.stream().map(list -> list.stream().map(String::length).max(Integer::compare)).collect(Collectors.toList());
        String string = linkedList.stream().map(list -> list.stream().map(String::valueOf).collect(Collectors.joining("|\n"))).collect(Collectors.joining("\n\n"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---\\\\\n").append(string).append("\n---////\n");
        return stringBuilder.toString();
    }

    private List<ResolvedFunction> optimizePath(List<List<ResolvedFunction>> list2, Class<?> clazz) {
        List<ResolvedFunction> list3 = null;
        List<ResolvedFunction> list4 = null;
        int n = -1;
        int n2 = 0;
        while (n != 0) {
            ++n2;
            n = 0;
            n += this.reduceByRequiredResultsType(list2.get(list2.size() - 1), clazz);
            if (list2.size() > 1) {
                int n3 = 0;
                for (List<ResolvedFunction> list5 : list2) {
                    ++n3;
                    list4 = list5;
                    if (list3 != null && list4 != null && n == 0 && (n += this.reduceByDirectTypes(list3, list4)) == 0 && (n += this.reduceByAssignableTypes(list3, list4, false)) == 0 && (n += this.reduceByAssignableTypes(list3, list4, true)) == 0) {
                        n += this.reduceByPreferredTypes(list3, list4);
                    }
                    list3 = list4;
                }
                list4 = null;
                list3 = null;
                continue;
            }
            n += this.reduceByPreferredResultTypes(list2.get(0));
        }
        List<ResolvedFunction> list6 = list2.stream().map(list -> (ResolvedFunction)list.get(0)).collect(Collectors.toList());
        return list6;
    }

    private int reduceByRequiredResultsType(List<ResolvedFunction> list, Class<?> clazz) {
        int n = 0;
        LinkedList<ResolvedFunction> linkedList = new LinkedList<ResolvedFunction>(list);
        for (ResolvedFunction resolvedFunction : linkedList) {
            if (clazz == null || ClassUtils.isAssignable(resolvedFunction.getResultClass(), clazz, (boolean)true)) continue;
            list.remove(resolvedFunction);
            String string = "BY-REQUIRED-RESULT-TYPE removed function '" + resolvedFunction + "' because is not assignable to " + clazz;
            logger.trace(string);
            ++n;
        }
        if (list.size() == 0) {
            throw new RuntimeException("BY-REQUIRED-RESULT-TYPE No end funcs were found which are assignable to " + clazz);
        }
        return n;
    }

    private int reduceByPreferredResultTypes(List<ResolvedFunction> list) {
        int n = 0;
        if (list.size() > 1) {
            n += list.size() - 1;
            list.sort(ResolvedFunction.PREFERRED_TYPE_COMPARATOR);
            while (list.size() > 1) {
                logger.trace("BY-SINGLE-PREFERRED-TYPE removing func " + list.get(list.size() - 1) + " because " + list.get(0) + " has more preferred types.");
                list.remove(list.size() - 1);
            }
        }
        return n;
    }

    private int reduceByPreferredTypes(List<ResolvedFunction> list, List<ResolvedFunction> list2) {
        int n;
        block3: {
            block2: {
                n = 0;
                if (list.size() <= 1) break block2;
                n += list.size() - 1;
                list.sort(ResolvedFunction.PREFERRED_TYPE_COMPARATOR);
                while (list.size() > 1) {
                    String string = "BY-PREV-PREFERRED-TYPE removing func " + list.get(list.size() - 1) + " because " + list.get(0) + " has more preferred types.";
                    logger.trace(string);
                    list.remove(list.size() - 1);
                }
                break block3;
            }
            if (list2.size() <= 1) break block3;
            n += list2.size() - 1;
            list2.sort(ResolvedFunction.PREFERRED_TYPE_COMPARATOR);
            while (list2.size() > 1) {
                String string = "BY-NEXT-PREFERRED-TYPE removing func " + list2.get(list2.size() - 1) + " because " + list2.get(0) + " has more preferred types.";
                logger.trace(string);
                list2.remove(list2.size() - 1);
            }
        }
        return n;
    }

    private int reduceByDirectTypes(List<ResolvedFunction> list, List<ResolvedFunction> list2) {
        int n = 0;
        Set<Class<?>> set = this.getOutputs(list);
        Set<Class<?>> set2 = this.getInputs(list2);
        Set set3 = set2.stream().filter(set::contains).collect(Collectors.toCollection(HashSet::new));
        if (set3.size() > 0) {
            ArrayList<ResolvedFunction> arrayList = new ArrayList<ResolvedFunction>();
            for (ResolvedFunction resolvedFunction : list2) {
                if (set3.contains(resolvedFunction.getArgType())) continue;
                String string = "BY-DIRECT-TYPE removing next func: " + resolvedFunction + " because its input types are not satisfied by any previous func";
                logger.trace(string);
                arrayList.add(resolvedFunction);
                ++n;
            }
            list2.removeAll(arrayList);
        }
        return n;
    }

    private int reduceByAssignableTypes(List<ResolvedFunction> list, List<ResolvedFunction> list2, boolean bl) {
        Set<Class<?>> set = this.getOutputs(list);
        Set<Class<?>> set2 = this.getInputs(list2);
        HashSet hashSet = new HashSet();
        for (Class<?> object : set2) {
            for (Class<?> clazz : set) {
                if (!ClassUtils.isAssignable(clazz, object, (boolean)bl)) continue;
                hashSet.add(object);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (ResolvedFunction resolvedFunction2 : list2) {
            if (hashSet.contains(resolvedFunction2.getInputClass())) continue;
            arrayList.add(resolvedFunction2);
        }
        if (arrayList.size() == list2.size()) {
            String string = "BY-ASSIGNABLE-TYPE Not removing remaining " + list2.size() + " next funcs " + (bl ? "with autoboxing " : "") + "because no functions would be left.";
            logger.trace(string);
            return 0;
        }
        arrayList.forEach(resolvedFunction -> {
            String string = "BY-ASSIGNABLE-TYPE removing next func: " + resolvedFunction + " because its input types are not assignable from any of the previous funcs";
            logger.trace(string);
        });
        list2.removeAll(arrayList);
        return arrayList.size();
    }

    private Set<Class<?>> getOutputs(List<ResolvedFunction> list) {
        HashSet hashSet = new HashSet();
        for (ResolvedFunction resolvedFunction : list) {
            hashSet.add(resolvedFunction.getResultClass());
        }
        return hashSet;
    }

    private Set<Class<?>> getInputs(List<ResolvedFunction> list) {
        HashSet hashSet = new HashSet();
        for (ResolvedFunction resolvedFunction : list) {
            hashSet.add(resolvedFunction.getArgType());
        }
        return hashSet;
    }

    public Map<String, ?> getCustomElements() {
        return this.customElements;
    }

    public VirtDataComposer addCustomElement(String string, Object object) {
        this.customElements.put(string, object);
        return this;
    }

    public VirtDataComposer addCustomElements(Map<String, ?> map) {
        this.customElements.putAll(map);
        return this;
    }
}

