/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.services.FunctionFinderService;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionFinder {
    private static final Logger logger = LoggerFactory.getLogger(FunctionFinder.class);

    public List<FunctionFinderService.Path> getFunctionNames() {
        ArrayList<FunctionFinderService.Path> paths = new ArrayList<FunctionFinderService.Path>();
        List finders = ServiceLoader.load(FunctionFinderService.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        logger.debug("Found " + finders.size() + " function enumerators in the runtime.");
        for (FunctionFinderService docFuncDataFinder : finders) {
            List funcNamesForModule = docFuncDataFinder.getFunctionPaths();
            logger.debug("Found " + funcNamesForModule.size() + " functions in library '" + docFuncDataFinder.getClass().getModule().getName());
            paths.addAll(funcNamesForModule);
        }
        return paths;
    }
}

