package io.virtdata.core;

import io.virtdata.autodoctypes.DocFuncData;
import io.virtdata.processors.FunctionDocInfoProcessor;
import io.virtdata.services.FunctionFinderService;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;

/**
 * This is the top-level API supporting access to the documentation models
 * for all known {@link io.virtdata.annotations.ThreadSafeMapper} and
 * {@link io.virtdata.annotations.PerThreadMapper} instances in the runtime.
 */
public class VirtDataDocs {

    private final static MethodHandles.Lookup lookup = MethodHandles.publicLookup();

    public static List<FunctionFinderService.Path> getAllNames() {
        FunctionFinder finder = new FunctionFinder();
        return finder.getFunctionNames();
    }

    public static List<DocFuncData> getAllDocs() {
        FunctionFinder finder = new FunctionFinder();
        List<FunctionFinderService.Path> functionNames = finder.getFunctionNames();

        List<DocFuncData> docs = new ArrayList<>();
        try {
            for (FunctionFinderService.Path n : functionNames) {

                Class<?> aClass =Class.forName(
                        n.finder.getClass().getModule(),
                         n.className + FunctionDocInfoProcessor.AUTOSUFFIX
                );

                MethodHandle constructor = lookup.findConstructor(aClass, MethodType.methodType(Void.TYPE));
                Object o = constructor.invoke();
                if (DocFuncData.class.isAssignableFrom(o.getClass())) {
                    docs.add(DocFuncData.class.cast(o));
                } else {
                    throw new RuntimeException("class " + o.getClass() + " could not be assigned to " + DocFuncData.class.getSimpleName());
                }
            }
        } catch (Throwable e) {
            throw new RuntimeException("Error while loading doc models:" + e.toString());
        }
        return docs;

    }
}
