/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.services.FunctionFinderService;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionFinder {
    private static final Logger logger = LoggerFactory.getLogger(FunctionFinder.class);

    public List<FunctionFinderService.Path> getFunctionNames() {
        ArrayList<FunctionFinderService.Path> paths = new ArrayList<FunctionFinderService.Path>();
        List finders = ServiceLoader.load(FunctionFinderService.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        logger.debug("Found " + finders.size() + " function enumerators in the runtime.");
        if (finders.size() == 0) {
            logger.error("This runtime could not find any FunctionFinderService endpoints using Java SPI with JPMS. This means that the dependencies might not be present which provide this service, or that themodule-info files are not configured with the correct provides or uses clause, or that the modules used in this runtime are not all using JPMS.");
        }
        for (FunctionFinderService docFuncDataFinder : finders) {
            List funcNamesForModule = docFuncDataFinder.getFunctionPaths();
            logger.debug("Found " + funcNamesForModule.size() + " functions in library '" + docFuncDataFinder.getClass().getModule().getName());
            paths.addAll(funcNamesForModule);
        }
        return paths;
    }
}

