/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.autodoctypes.DocFuncData;
import io.virtdata.core.FunctionFinder;
import io.virtdata.services.FunctionFinderService;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;

public class VirtDataDocs {
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();

    public static List<FunctionFinderService.Path> getAllNames() {
        FunctionFinder finder = new FunctionFinder();
        return finder.getFunctionNames();
    }

    public static List<DocFuncData> getAllDocs() {
        FunctionFinder finder = new FunctionFinder();
        List<FunctionFinderService.Path> functionNames = finder.getFunctionNames();
        ArrayList<DocFuncData> docs = new ArrayList<DocFuncData>();
        try {
            for (FunctionFinderService.Path n : functionNames) {
                Class<?> aClass = Class.forName(n.finder.getClass().getModule(), n.className + "AutoDocsInfo");
                MethodHandle constructor = lookup.findConstructor(aClass, MethodType.methodType(Void.TYPE));
                Object o = constructor.invoke();
                if (DocFuncData.class.isAssignableFrom(o.getClass())) {
                    docs.add((DocFuncData)DocFuncData.class.cast(o));
                    continue;
                }
                throw new RuntimeException("class " + o.getClass() + " could not be assigned to " + DocFuncData.class.getSimpleName());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while loading doc models:" + e.toString());
        }
        return docs;
    }
}

