/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.core.FunctionFinder;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.services.FunctionFinderService;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataFunctionResolver {
    private static final Logger logger = LoggerFactory.getLogger(VirtDataFunctionResolver.class);
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private final FunctionFinder functionFinder = new FunctionFinder();

    public List<ResolvedFunction> resolveFunctions(Class<?> returnType, Class<?> inputType, String functionName, Object ... parameters) {
        StringBuilder rs = new StringBuilder();
        rs.append(inputType == null ? "ANY" : inputType.getSimpleName());
        rs.append("->").append(functionName).append("(");
        rs.append(Arrays.stream(parameters).map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(",")));
        rs.append(")->");
        rs.append(returnType == null ? "ANY" : returnType.getSimpleName());
        String requestedSignature = rs.toString();
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        ArrayList<ResolvedFunction> resolvedFunctions = new ArrayList<ResolvedFunction>();
        List<FunctionFinderService.Path> functionNames = this.functionFinder.getFunctionNames();
        logger.trace("considering " + functionNames.size() + " different functions for '" + requestedSignature);
        List matchingClasses = functionNames.stream().filter(p -> p.className.endsWith("." + functionName)).map(this::maybeClassForName).filter(Objects::nonNull).collect(Collectors.toList());
        logger.trace("found " + matchingClasses.size() + " matching classes with the same simple name '" + functionName + "'");
        List matchingConstructors = null;
        matchingConstructors = matchingClasses.stream().filter(c -> {
            boolean matchesSignature;
            boolean isFunctional = this.isFunctionalInterface((Class<?>)c);
            boolean canAssignInput = inputType == null || this.canAssignInputType((Class<?>)c, inputType);
            boolean canAssignReturn = returnType == null || this.canAssignReturnType((Class<?>)c, returnType);
            boolean bl = matchesSignature = isFunctional && canAssignInput && canAssignReturn;
            if (!matchesSignature) {
                logger.trace("rejected: functional?=" + isFunctional + ", input type ok?=" + canAssignInput + ", output type ok?=" + canAssignReturn);
            }
            return matchesSignature;
        }).flatMap(c -> Arrays.stream(c.getDeclaredConstructors())).filter(c -> {
            logger.trace("considering " + this.getEffectiveSignature((Constructor)c));
            Class[] ctypes = c.getParameterTypes();
            if (c.isVarArgs()) {
                if (!ClassUtils.isAssignable((Class[])Arrays.copyOfRange(parameterTypes, 0, ctypes.length - 1), (Class[])Arrays.copyOfRange(ctypes, 0, ctypes.length - 1), (boolean)true)) {
                    logger.trace(" rejected: varargs types are not assignable from the input values");
                    return false;
                }
                Class<?> componentType = ctypes[ctypes.length - 1].getComponentType();
                if (parameterTypes.length >= ctypes.length && !ClassUtils.isAssignable((Class)parameterTypes[ctypes.length - 1], componentType, (boolean)true)) {
                    logger.trace(" rejected: varargs type is not assignable from the input value type");
                    return false;
                }
                return true;
            }
            if (parameterTypes.length != ctypes.length) {
                logger.trace(" rejected: the ctor has " + ctypes.length + " parameters, but " + parameterTypes.length + " are provided.");
                return false;
            }
            boolean assignable = ClassUtils.isAssignable((Class[])parameterTypes, (Class[])ctypes, (boolean)true);
            if (!assignable) {
                logger.trace(" rejected: parameter types are not assignable to signature");
            }
            return assignable;
        }).collect(Collectors.toList());
        logger.debug("found " + matchingConstructors.size() + " matching constructors which can fulfill " + requestedSignature);
        if (!logger.isTraceEnabled()) {
            logger.debug("see TRACE level logs for details.");
        }
        if (returnType != null && inputType != null && matchingConstructors.size() > 1) {
            throw new RuntimeException("found more than one (" + matchingConstructors.size() + ") matching constructor for return type '" + returnType + "', inputType '" + inputType + "', function name '" + functionName + ", and parameter types '" + Arrays.toString(parameters) + "', ctors: " + matchingConstructors);
        }
        for (Constructor ctor : matchingConstructors) {
            try {
                Class ctorDClass = ctor.getDeclaringClass();
                MethodType ctorMethodType = MethodType.methodType(Void.TYPE, ctor.getParameterTypes());
                MethodHandle constructor = lookup.findConstructor(ctorDClass, ctorMethodType);
                Object functionalInstance = constructor.invokeWithArguments(parameters);
                boolean threadSafe = functionalInstance.getClass().getAnnotation(ThreadSafeMapper.class) != null;
                resolvedFunctions.add(new ResolvedFunction(functionalInstance, threadSafe, parameterTypes, parameters, this.getInputClass(functionalInstance.getClass()), this.getOutputClas(functionalInstance.getClass())));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return resolvedFunctions;
    }

    private boolean isFunctionalInterface(Class<?> c) {
        Optional<Method> applyMethods = Arrays.stream(c.getMethods()).filter(m -> {
            boolean isNotDefault = !m.isDefault();
            boolean isNotBridge = !m.isBridge();
            boolean isNotSynthetic = !m.isSynthetic();
            boolean isPublic = (m.getModifiers() & 1) > 0;
            boolean isNotString = !m.getName().equals("toString");
            boolean isApplyMethod = m.getName().startsWith("apply");
            boolean isFunctional = isNotDefault && isNotBridge && isNotSynthetic && isPublic && isNotString && isApplyMethod;
            return isFunctional;
        }).findFirst();
        return applyMethods.isPresent();
    }

    private boolean canAssignArguments(Constructor<?> targetCtor, Object[] sourceParameters) {
        int i;
        boolean isAssignable = true;
        Class<?>[] targetTypes = targetCtor.getParameterTypes();
        if (targetCtor.isVarArgs()) {
            if (sourceParameters.length < targetTypes.length - 1) {
                logger.trace(targetCtor.toString() + " (varargs) does not match, not enough source parameters: " + Arrays.toString(sourceParameters));
                return false;
            }
        } else if (sourceParameters.length != targetTypes.length) {
            logger.trace(targetCtor.toString() + " (varargs) does not match source parameters (size): " + Arrays.toString(sourceParameters));
            return false;
        }
        Class[] sourceTypes = new Class[sourceParameters.length];
        for (i = 0; i < sourceTypes.length; ++i) {
            sourceTypes[i] = sourceParameters[i].getClass();
        }
        if (targetCtor.isVarArgs()) {
            for (i = 0; i < targetTypes.length - 1; ++i) {
                if (ClassUtils.isAssignable((Class)sourceTypes[i], targetTypes[i])) continue;
                isAssignable = false;
                break;
            }
            Class<?> componentType = targetTypes[targetTypes.length - 1].getComponentType();
            for (int i2 = targetTypes.length - 1; i2 < sourceTypes.length; ++i2) {
                if (ClassUtils.isAssignable((Class)sourceTypes[i2], componentType, (boolean)true)) continue;
                isAssignable = false;
                break;
            }
        } else {
            for (i = 0; i < targetTypes.length; ++i) {
                if (ClassUtils.isAssignable((Class)sourceTypes[i], targetTypes[i])) continue;
                isAssignable = false;
                break;
            }
        }
        return isAssignable;
    }

    private boolean canAssignReturnType(Class<?> functionalClass, Class<?> returnType) {
        Class<?> sourceType = this.toFunctionalMethod(functionalClass).getReturnType();
        boolean isAssignable = returnType.isAssignableFrom(sourceType);
        return isAssignable;
    }

    private Class<?> getInputClass(Class<?> functionalClass) {
        return this.toFunctionalMethod(functionalClass).getParameterTypes()[0];
    }

    private Class<?> getOutputClas(Class<?> functionClass) {
        return this.toFunctionalMethod(functionClass).getReturnType();
    }

    private boolean canAssignInputType(Class<?> functionalClass, Class<?> inputType) {
        boolean isAssignable = this.toFunctionalMethod(functionalClass).getParameterTypes()[0].isAssignableFrom(inputType);
        return isAssignable;
    }

    private Class<?> maybeClassForName(FunctionFinderService.Path path) {
        try {
            return Class.forName(path.finder.getClass().getModule(), path.className);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getEffectiveSignature(Constructor ctor) {
        StringBuilder sb = new StringBuilder();
        Method fmethod = this.toFunctionalMethod(ctor.getDeclaringClass());
        sb.append(fmethod.getParameterTypes()[0].getTypeName()).append("->");
        sb.append(ctor.getDeclaringClass().getCanonicalName()).append("(");
        for (Class<?> parameterType : ctor.getParameterTypes()) {
            sb.append(parameterType.getTypeName()).append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")->");
        sb.append(fmethod.getReturnType().getTypeName());
        return sb.toString();
    }

    private Method toFunctionalMethod(Class<?> clazz) {
        Optional<Method> foundMethod = Arrays.stream(clazz.getMethods()).filter(m -> !m.isDefault() && !m.isBridge() && !m.isSynthetic()).filter(m -> m.getName().startsWith("apply")).findFirst();
        return foundMethod.orElseThrow(() -> new RuntimeException("Unable to find the function method on " + clazz.getCanonicalName()));
    }

    public List<FunctionFinderService.Path> getFunctionNames() {
        return this.functionFinder.getFunctionNames();
    }
}

