/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.api.config.ConfigAware;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.core.VirtDataFunctionFinder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataFunctionResolver {
    private static final Logger logger = LoggerFactory.getLogger(VirtDataFunctionResolver.class);
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private final VirtDataFunctionFinder virtDataFunctionFinder = new VirtDataFunctionFinder();

    public List<ResolvedFunction> resolveFunctions(Class<?> clazz2, Class<?> clazz4, String string, Map<String, ?> map, Object ... objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        ArrayList<ResolvedFunction> arrayList = new ArrayList<ResolvedFunction>();
        List list = this.virtDataFunctionFinder.getFunctionNames().stream().filter(string2 -> string2.endsWith("." + string)).map(this::maybeClassForName).filter(Objects::nonNull).collect(Collectors.toList());
        List list2 = null;
        list2 = list.stream().filter(clazz3 -> {
            boolean bl = this.isFunctionalInterface((Class<?>)clazz3);
            boolean bl2 = clazz4 == null || this.canAssignInputType((Class<?>)clazz3, clazz4);
            boolean bl3 = clazz2 == null || this.canAssignReturnType((Class<?>)clazz3, clazz2);
            boolean bl4 = bl && bl2 && bl3;
            return bl4;
        }).flatMap(clazz -> Arrays.stream(clazz.getDeclaredConstructors())).filter(constructor -> {
            Class[] classArray2 = constructor.getParameterTypes();
            if (constructor.isVarArgs()) {
                int n = Math.min(classArray2.length - 1, objectArray.length);
                Class[] classArray3 = Arrays.copyOfRange(classArray, 0, n);
                Class[] classArray4 = Arrays.copyOfRange(classArray2, 0, n);
                if (objectArray.length < classArray2.length - 1) {
                    return false;
                }
                if (!ClassUtils.isAssignable((Class[])classArray3, (Class[])classArray4, (boolean)true)) {
                    return false;
                }
                Class<?> clazz = classArray2[classArray2.length - 1].getComponentType();
                return classArray.length < classArray2.length || ClassUtils.isAssignable((Class)classArray[classArray2.length - 1], clazz, (boolean)true);
            }
            if (classArray.length != classArray2.length) {
                return false;
            }
            return ClassUtils.isAssignable((Class[])classArray, (Class[])classArray2, (boolean)true);
        }).collect(Collectors.toList());
        if (clazz2 != null && clazz4 != null && list2.size() > 1) {
            throw new RuntimeException("found more than one (" + list2.size() + ") matching constructor for return type '" + clazz2 + "', inputType '" + clazz4 + "', function name '" + string + ", and parameter types '" + Arrays.toString(objectArray) + "', ctors: " + list2);
        }
        for (Constructor constructor2 : list2) {
            try {
                Class clazz5 = constructor2.getDeclaringClass();
                MethodType methodType = MethodType.methodType(Void.TYPE, constructor2.getParameterTypes());
                MethodHandle methodHandle = lookup.findConstructor(clazz5, methodType);
                Object object = methodHandle.invokeWithArguments(objectArray);
                if (object instanceof ConfigAware) {
                    ((ConfigAware)object).applyConfig(map);
                }
                boolean bl = object.getClass().getAnnotation(ThreadSafeMapper.class) != null;
                arrayList.add(new ResolvedFunction(object, bl, classArray, objectArray, this.getInputClass(object.getClass()), this.getOutputClass(object.getClass())));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return arrayList;
    }

    private boolean isFunctionalInterface(Class<?> clazz) {
        Optional<Method> optional = Arrays.stream(clazz.getMethods()).filter(method -> {
            boolean bl = !method.isDefault();
            boolean bl2 = !method.isBridge();
            boolean bl3 = !method.isSynthetic();
            boolean bl4 = (method.getModifiers() & 1) > 0;
            boolean bl5 = !method.getName().equals("toString");
            boolean bl6 = method.getName().startsWith("apply");
            boolean bl7 = bl && bl2 && bl3 && bl4 && bl5 && bl6;
            return bl7;
        }).findFirst();
        return optional.isPresent();
    }

    private boolean canAssignArguments(Constructor<?> constructor, Object[] objectArray) {
        int n;
        boolean bl = true;
        Class<?>[] classArray = constructor.getParameterTypes();
        if (constructor.isVarArgs()) {
            if (objectArray.length < classArray.length - 1) {
                logger.trace(constructor.toString() + " (varargs) does not match, not enough source parameters: " + Arrays.toString(objectArray));
                return false;
            }
        } else if (objectArray.length != classArray.length) {
            logger.trace(constructor.toString() + " (varargs) does not match source parameters (size): " + Arrays.toString(objectArray));
            return false;
        }
        Class[] classArray2 = new Class[objectArray.length];
        for (n = 0; n < classArray2.length; ++n) {
            classArray2[n] = objectArray[n].getClass();
        }
        if (constructor.isVarArgs()) {
            for (n = 0; n < classArray.length - 1; ++n) {
                if (ClassUtils.isAssignable((Class)classArray2[n], classArray[n])) continue;
                bl = false;
                break;
            }
            Class<?> clazz = classArray[classArray.length - 1].getComponentType();
            for (int i = classArray.length - 1; i < classArray2.length; ++i) {
                if (ClassUtils.isAssignable((Class)classArray2[i], clazz, (boolean)true)) continue;
                bl = false;
                break;
            }
        } else {
            for (n = 0; n < classArray.length; ++n) {
                if (ClassUtils.isAssignable((Class)classArray2[n], classArray[n])) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private boolean canAssignReturnType(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3 = this.toFunctionalMethod(clazz).getReturnType();
        boolean bl = clazz2.isAssignableFrom(clazz3);
        return bl;
    }

    private Class<?> getInputClass(Class<?> clazz) {
        return this.toFunctionalMethod(clazz).getParameterTypes()[0];
    }

    private Class<?> getOutputClass(Class<?> clazz) {
        return this.toFunctionalMethod(clazz).getReturnType();
    }

    private boolean canAssignInputType(Class<?> clazz, Class<?> clazz2) {
        boolean bl = this.toFunctionalMethod(clazz).getParameterTypes()[0].isAssignableFrom(clazz2);
        return bl;
    }

    private Class<?> maybeClassForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method toFunctionalMethod(Class<?> clazz) {
        Optional<Method> optional = Arrays.stream(clazz.getMethods()).filter(method -> !method.isDefault() && !method.isBridge() && !method.isSynthetic()).filter(method -> method.getName().startsWith("apply")).findFirst();
        return optional.orElseThrow(() -> new RuntimeException("Unable to find the function method on " + clazz.getCanonicalName()));
    }

    public List<String> getFunctionNames() {
        return this.virtDataFunctionFinder.getFunctionNames();
    }
}

