/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.core;

import io.virtdata.docsys.api.DocSystemEndpoint;
import io.virtdata.docsys.core.EndpointLoader;
import io.virtdata.docsys.handlers.EndpointsHandler;
import io.virtdata.docsys.handlers.FavIconHandler;
import io.virtdata.docsys.metafs.fs.layerfs.LayerFS;
import io.virtdata.docsys.metafs.fs.renderfs.api.FileRenderer;
import io.virtdata.docsys.metafs.fs.renderfs.fs.RenderFS;
import io.virtdata.docsys.metafs.fs.renderfs.renderers.MarkdownProcessor;
import io.virtdata.docsys.metafs.fs.renderfs.renderers.MarkdownProcessorDebugger;
import io.virtdata.docsys.metafs.fs.renderfs.renderers.MustacheProcessor;
import io.virtdata.docsys.metafs.fs.virtual.VirtFS;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocServer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DocServer.class);
    private final List<Path> basePaths = new ArrayList<Path>();
    private final List<Object> servletObjects = new ArrayList<Object>();
    private ServletContextHandler contextHandler;
    private ServletHolder servlets;
    private String bindHost = "localhost";
    private int bindPort = 12345;

    public DocServer withHost(String bindHost) {
        this.bindHost = bindHost;
        return this;
    }

    public DocServer withPort(int bindPort) {
        this.bindPort = bindPort;
        return this;
    }

    public DocServer addWebObject(Object ... objects) {
        this.servletObjects.addAll(Arrays.asList(objects));
        this.getServlets().setInitParameter("jersey.config.server.provider.classnames", this.servletObjects.stream().map(o -> o.getClass().getCanonicalName()).collect(Collectors.joining(",")));
        return this;
    }

    private ServletContextHandler getContextHandler() {
        if (this.contextHandler == null) {
            this.contextHandler = new ServletContextHandler();
            this.contextHandler.setContextPath("/");
        }
        return this.contextHandler;
    }

    private ServletHolder getServlets() {
        if (this.servlets == null) {
            this.servlets = this.getContextHandler().addServlet(ServletContainer.class, "/*");
        }
        return this.servlets;
    }

    public DocServer addPaths(Path ... paths) {
        this.basePaths.addAll(Arrays.asList(paths));
        return this;
    }

    @Override
    public void run() {
        Server server = new Server(this.bindPort);
        HandlerList handlers = new HandlerList();
        FavIconHandler favIconHandler = new FavIconHandler(this.basePaths.get(0) + "/favicon.ico", false);
        handlers.addHandler((Handler)favIconHandler);
        EndpointsHandler endpointsHandler = new EndpointsHandler();
        handlers.addHandler((Handler)endpointsHandler);
        LayerFS layerfs = new LayerFS();
        for (Path basePath : this.basePaths) {
            VirtFS vfs = new VirtFS(basePath);
            RenderFS rfs = new RenderFS(vfs);
            MustacheProcessor msp = new MustacheProcessor();
            MarkdownProcessor mdp = new MarkdownProcessor();
            MarkdownProcessorDebugger mdd = new MarkdownProcessorDebugger();
            FileRenderer htmlRenderer = new FileRenderer(".md", ".html", false, msp, mdp);
            rfs.addRenderer(htmlRenderer);
            MustacheProcessor ms_html = new MustacheProcessor();
            FileRenderer mustacheToHtmlRenderer = new FileRenderer(".mustache_html", ".html", false, ms_html);
            rfs.addRenderer(mustacheToHtmlRenderer);
            MustacheProcessor ms_md = new MustacheProcessor();
            FileRenderer mustacheToMarkdown = new FileRenderer(".mustache_md", ".md", false, ms_md);
            rfs.addRenderer(mustacheToMarkdown);
            layerfs.addLayer(rfs);
        }
        PathResource baseResource = new PathResource(layerfs.getRootPath());
        logger.info("Setting root path of server: " + baseResource.toString());
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirAllowed(true);
        resourceHandler.setAcceptRanges(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        resourceHandler.setRedirectWelcome(true);
        resourceHandler.setBaseResource((Resource)baseResource);
        handlers.addHandler((Handler)resourceHandler);
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setShowContexts(true);
        defaultHandler.setServeIcon(false);
        List<DocSystemEndpoint> autoendpoints = EndpointLoader.load();
        autoendpoints.forEach(e -> {
            if (!this.servletObjects.contains(e)) {
                this.servletObjects.add(e);
            }
        });
        if (this.servletObjects.size() > 0) {
            logger.info("adding " + this.servletObjects.size() + " context handlers");
            handlers.addHandler((Handler)this.getContextHandler());
        } else {
            logger.info("No context handlers defined, not adding context container.");
        }
        handlers.addHandler((Handler)defaultHandler);
        server.setHandler((Handler)handlers);
        try {
            server.start();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

