/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.core;

import io.virtdata.docsys.metafs.core.MetaFS;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MetaPath
implements Path {
    protected final String[] path;
    private final MetaFS filesystem;
    private final boolean isAbsolute;

    public MetaPath(MetaFS metaFS, String initial, String ... remaining) {
        this.filesystem = metaFS;
        this.isAbsolute = initial.startsWith(FileSystems.getDefault().getSeparator());
        if (this.isAbsolute) {
            initial = initial.substring(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(initial);
        sb.append(FileSystems.getDefault().getSeparator());
        for (String s : remaining) {
            sb.append(s);
        }
        this.path = MetaPath.normalize(sb.toString().split(Pattern.quote(FileSystems.getDefault().getSeparator())));
    }

    public MetaPath(MetaFS metaFS, String[] components, boolean absolute) {
        this.filesystem = metaFS;
        this.path = components;
        this.isAbsolute = absolute;
    }

    private static String[] normalize(String[] components) {
        String[] target = new String[components.length];
        int targetidx = 0;
        String sep = FileSystems.getDefault().getSeparator();
        int levels = 0;
        for (int i = 0; i < components.length; ++i) {
            if (i == 0 && components[i].equals(".")) {
                target[targetidx] = components[i];
                ++targetidx;
                continue;
            }
            if (components[i].equals("..") && targetidx > 0) {
                target[--targetidx] = null;
                continue;
            }
            if (i > 0 && components[i].equals(sep) && components[i - 1].equals(sep) || components[i].isEmpty()) continue;
            target[targetidx] = components[i];
            ++targetidx;
        }
        for (int backlevels = 0; backlevels < levels; ++backlevels) {
            target[targetidx] = "..";
            ++targetidx;
        }
        if (targetidx == components.length) {
            return components;
        }
        String[] sbuf = new String[targetidx];
        System.arraycopy(target, 0, sbuf, 0, targetidx);
        return sbuf;
    }

    @Override
    public MetaFS getFileSystem() {
        return this.filesystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    @Override
    public Path getRoot() {
        if (this.isAbsolute) {
            return new MetaPath(this.filesystem, FileSystems.getDefault().getSeparator(), new String[0]);
        }
        return null;
    }

    @Override
    public Path getFileName() {
        if (this.path.length == 0) {
            return null;
        }
        return new MetaPath(this.filesystem, this.path[this.path.length - 1], new String[0]);
    }

    @Override
    public Path getParent() {
        if (this.path.length == 0) {
            return null;
        }
        String[] parentArray = new String[this.path.length - 1];
        System.arraycopy(this.path, 0, parentArray, 0, parentArray.length);
        return new MetaPath(this.filesystem, parentArray, this.isAbsolute);
    }

    @Override
    public int getNameCount() {
        return this.path.length;
    }

    @Override
    public Path getName(int index) {
        return new MetaPath(this.filesystem, this.path[index], new String[0]);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.path.length - 1) {
            throw new InvalidParameterException("Index range must be within available path name count: 0 < begin(" + beginIndex + ") <= end(" + endIndex + ") <= " + (this.path.length - 1) + " ?");
        }
        int len = endIndex - beginIndex + 1;
        String[] components = new String[len];
        System.arraycopy(this.path, beginIndex, components, 0, len);
        return new MetaPath(this.filesystem, components, false);
    }

    @Override
    public boolean startsWith(Path other) {
        if (this.path.length < other.getNameCount()) {
            return false;
        }
        if (this.getFileSystem() != other.getFileSystem()) {
            return false;
        }
        if (this.isAbsolute != other.isAbsolute()) {
            return false;
        }
        for (int i = 0; i < other.getNameCount(); ++i) {
            if (this.path[i].equals(other.getName(i).toString())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(Path other) {
        if (other.isAbsolute()) {
            return false;
        }
        if (this.getNameCount() < other.getNameCount()) {
            return false;
        }
        for (int i = 0; i < other.getNameCount(); ++i) {
            if (this.path[this.path.length - i].equals(other.getName(other.getNameCount() - (i + 1)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Path normalize() {
        String[] normalized = MetaPath.normalize(this.path);
        if (normalized != this.path) {
            return new MetaPath(this.filesystem, normalized, this.isAbsolute);
        }
        return this;
    }

    @Override
    public Path resolve(Path other) {
        MetaPath ometa = this.assertMetaPath(other);
        if (ometa.isAbsolute()) {
            return other;
        }
        if (ometa.path.length == 0) {
            return this;
        }
        String[] resolved = new String[this.path.length + ometa.path.length];
        System.arraycopy(this.path, 0, resolved, 0, this.path.length);
        System.arraycopy(ometa.path, 0, resolved, this.path.length, ometa.path.length);
        return new MetaPath(this.filesystem, resolved, this.isAbsolute);
    }

    @Override
    public Path relativize(Path other) {
        int common_idx;
        MetaPath mpath = this.assertMetaPath(other);
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new IllegalArgumentException("Unable to relativize '" + other + "' against '" + this + "');");
        }
        for (common_idx = 0; common_idx < this.path.length && this.path[common_idx].equals(mpath.path[common_idx]); ++common_idx) {
        }
        int back_idx = this.path.length - common_idx;
        String[] sbuf = new String[back_idx + (mpath.path.length - common_idx)];
        for (int updir = 0; updir < back_idx; ++updir) {
            sbuf[updir] = "..";
        }
        System.arraycopy(mpath.path, common_idx, sbuf, back_idx, mpath.path.length - common_idx);
        return new MetaPath(this.filesystem, sbuf, false);
    }

    @Override
    public Path toAbsolutePath() {
        return this.getRoot().resolve(this);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.toAbsolutePath();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return null;
    }

    @Override
    public int compareTo(Path other) {
        int thisSize = this.getNameCount();
        int thatSize = other.getNameCount();
        int commonIdx = Math.min(thisSize, thatSize);
        for (int i = 0; i < commonIdx; ++i) {
            int diff = this.getName(i).compareTo(other.getName(i));
            if (diff == 0) continue;
            return diff;
        }
        return Integer.compare(thisSize, thatSize);
    }

    private Path tmpSysPath(MetaPath other) {
        return FileSystems.getDefault().getPath((other.isAbsolute() ? FileSystems.getDefault().getSeparator() : "") + other.path[0], Arrays.copyOfRange(other.path, 1, other.path.length - 1));
    }

    private void assertFilesystemOwnership(Path other) {
        if (other.getFileSystem() != this.filesystem) {
            throw new InvalidParameterException("This path is from a different filesystem.");
        }
        if (!(other instanceof MetaPath)) {
            throw new InvalidParameterException("This path is not of type MetaPath");
        }
    }

    private String joinedPath() {
        StringBuilder sb = new StringBuilder();
        if (this.isAbsolute()) {
            sb.append(FileSystems.getDefault().getSeparator());
        }
        for (String s : this.path) {
            sb.append(s);
            sb.append(FileSystems.getDefault().getSeparator());
        }
        try {
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 1);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return (this.isAbsolute() ? FileSystems.getDefault().getSeparator() : "") + Arrays.stream(this.path).collect(Collectors.joining(this.getFileSystem().getSeparator()));
    }

    public MetaPath asRelativePath() {
        return new MetaPath(this.filesystem, this.path, false);
    }

    @Override
    public URI toUri() {
        try {
            Object joinedpath = this.joinedPath();
            BasicFileAttributeView fav = this.filesystem.provider().getFileAttributeView(this, BasicFileAttributeView.class, new LinkOption[0]);
            if (!((String)joinedpath).endsWith("/") && fav.readAttributes().isDirectory()) {
                joinedpath = (String)joinedpath + "/";
            }
            return new URI(this.filesystem.provider().getScheme(), null, (String)joinedpath, null);
        }
        catch (URISyntaxException e) {
            throw new InvalidParameterException("Unable to create URI from " + this + ": " + e.getInput());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to read attributes for " + this.toString());
        }
    }

    private MetaPath assertMetaPath(Path other) {
        if (other instanceof MetaPath) {
            MetaPath metapath = (MetaPath)other;
            if (metapath.getFileSystem() != this.getFileSystem()) {
                throw new InvalidParameterException("Using paths from two different filesystems: (this) " + this.getFileSystem().toString() + " (other) " + other.getFileSystem().toString());
            }
            return metapath;
        }
        throw new InvalidParameterException("expected a MetaPath instance, got " + other.getClass().getCanonicalName() + " instead");
    }

    @Override
    public File toFile() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaPath paths = (MetaPath)o;
        if (this.isAbsolute != paths.isAbsolute) {
            return false;
        }
        if (!Arrays.equals(this.path, paths.path)) {
            return false;
        }
        return this.filesystem != null ? this.filesystem.equals(paths.filesystem) : paths.filesystem == null;
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode(this.path);
        result = 31 * result + (this.filesystem != null ? this.filesystem.hashCode() : 0);
        result = 31 * result + (this.isAbsolute ? 1 : 0);
        return result;
    }
}

