/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.layerfs;

import io.virtdata.docsys.metafs.core.MetaFS;
import io.virtdata.docsys.metafs.core.MetaPath;
import io.virtdata.docsys.metafs.fs.layerfs.LayerFSProvider;
import io.virtdata.docsys.metafs.fs.virtual.VirtFS;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerFS
extends MetaFS {
    private static final Logger logger = LoggerFactory.getLogger(LayerFS.class);
    private static LayerFSProvider provider = LayerFSProvider.get();
    private List<FileSystem> wrappedFilesystems = new ArrayList<FileSystem>();

    public LayerFS setWritable(boolean writable) {
        this.isReadOnly = !writable;
        return this;
    }

    public LayerFS addLayer(Path outerPath) {
        VirtFS metafs = new VirtFS(outerPath);
        this.wrappedFilesystems.add(metafs);
        return this;
    }

    public LayerFS addLayer(FileSystem fileSystem) {
        this.wrappedFilesystems.add(fileSystem);
        return this;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        HashSet<String> pathNames = new HashSet<String>();
        HashSet<Path> paths = new HashSet<Path>();
        for (FileSystem fileSystem : this.wrappedFilesystems) {
            for (Path rootDirectory : fileSystem.getRootDirectories()) {
                String dirName = rootDirectory.toString();
                if (pathNames.contains(dirName)) continue;
                pathNames.add(dirName);
                paths.add(rootDirectory);
            }
        }
        return paths;
    }

    @Override
    public LayerFSProvider provider() {
        return provider;
    }

    @Override
    public String getSeparator() {
        if (this.wrappedFilesystems.size() > 0) {
            return this.wrappedFilesystems.get(0).getSeparator();
        }
        return FileSystems.getDefault().getSeparator();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return () -> this.wrappedFilesystems.stream().map(FileSystem::getFileStores).map(f -> StreamSupport.stream(f.spliterator(), false)).flatMap(i -> StreamSupport.stream(i.spliterator(), false)).iterator();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        if (this.wrappedFilesystems.size() == 0) {
            return new HashSet<String>();
        }
        Set<String> sfav = null;
        for (FileSystem fileSystem : this.wrappedFilesystems) {
            if (sfav == null) {
                sfav = fileSystem.supportedFileAttributeViews();
                continue;
            }
            sfav.retainAll(fileSystem.supportedFileAttributeViews());
        }
        return sfav;
    }

    @Override
    public Path getPath(String first, String ... more) {
        return new MetaPath((MetaFS)this, first, more);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        MetaPath metapath = this.assertMetaPath(path);
        LayerFS layerFS = this.assertThisFs(metapath);
        if (options.contains(StandardOpenOption.READ) || options.isEmpty()) {
            Path firstReadablePath = this.findFirstReadablePath(metapath, layerFS.getWrappedFilesystems());
            return firstReadablePath.getFileSystem().provider().newByteChannel(firstReadablePath, options, attrs);
        }
        Path firstWritablePath = this.findFirstWritablePath(metapath, layerFS.getWrappedFilesystems());
        return firstWritablePath.getFileSystem().provider().newByteChannel(firstWritablePath, options, attrs);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return null;
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return null;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return null;
    }

    public List<FileSystem> getWrappedFilesystems() {
        return this.wrappedFilesystems;
    }

    public String toString() {
        return "LayerFS:" + this.wrappedFilesystems.stream().map(String::valueOf).collect(Collectors.joining(",", "[[", "]]"));
    }

    private LayerFS assertThisFs(MetaPath path) {
        if (path.getFileSystem() != this) {
            throw new RuntimeException("Unable to do LayerFS operations on Path from a different filesystem " + path.getFileSystem().getClass().getCanonicalName());
        }
        return (LayerFS)path.getFileSystem();
    }

    private MetaPath assertMetaPath(Path path) {
        if (!(path instanceof MetaPath)) {
            throw new InvalidParameterException("Unable to do MetaPath operations on Path of type " + path.getClass().getCanonicalName());
        }
        return (MetaPath)path;
    }

    private Path findFirstWritablePath(Path toWrite, List<FileSystem> fileSystems) {
        for (FileSystem fs : fileSystems) {
            if (fs.isReadOnly()) continue;
            return fs.getPath(toWrite.toString(), new String[0]);
        }
        throw new RuntimeException("Unable to find a writable filesystem in addLayers.");
    }

    private Path findFirstReadablePath(Path toRead, List<FileSystem> fileSystems) {
        for (FileSystem fileSystem : fileSystems) {
            try {
                Path fsSpecificPath = fileSystem.getPath(toRead.toString(), new String[0]);
                fsSpecificPath.getFileSystem().provider().checkAccess(fsSpecificPath, AccessMode.READ);
                return fsSpecificPath;
            }
            catch (IOException e) {
                logger.warn("Did not find readable file " + toRead + " in fs " + fileSystem);
            }
        }
        throw new RuntimeException("Unable to find a readable " + toRead + " in any addLayer");
    }
}

