/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Function;

public class RendererIO {
    public static Function<Path, ByteBuffer> PATH_BUFFER_FUNCTION = RendererIO::readBuffer;

    public static String readString(Path path) {
        try {
            InputStream inputStream = path.getFileSystem().provider().newInputStream(path, new OpenOption[0]);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            inputStream.transferTo(bos);
            return new String(bos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer readBuffer(Path path) {
        try {
            InputStream inputStream = path.getFileSystem().provider().newInputStream(path, new OpenOption[0]);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            inputStream.transferTo(bos);
            return ByteBuffer.wrap(bos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BasicFileAttributes getFileAttributes(Path path) {
        try {
            BasicFileAttributeView fileAttributeView = path.getFileSystem().provider().getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
            return fileAttributeView.readAttributes();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long mtimeFor(Path path) {
        return RendererIO.getFileAttributes(path).lastModifiedTime().toMillis();
    }
}

