/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import io.virtdata.docsys.metafs.fs.renderfs.api.FileContentRenderer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class Renderers {
    private LinkedList<FileContentRenderer> rendererTypes = new LinkedList();

    public void add(FileContentRenderer renderer) {
        this.rendererTypes.add(renderer);
    }

    public List<FileContentRenderer> getRendererTypes() {
        return Collections.unmodifiableList(this.rendererTypes);
    }

    public FileContentRenderer forTargetPath(Path path) {
        for (FileContentRenderer rendererType : this.rendererTypes) {
            if (!rendererType.canRender(path)) continue;
            return rendererType;
        }
        return null;
    }

    public String toString() {
        return this.rendererTypes.stream().map(String::valueOf).collect(Collectors.joining(",", "[", "]"));
    }
}

