/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.model;

import io.virtdata.docsys.metafs.fs.renderfs.api.MarkdownStringer;
import io.virtdata.docsys.metafs.fs.renderfs.api.Versioned;
import io.virtdata.docsys.metafs.fs.renderfs.model.properties.ListView;
import io.virtdata.docsys.metafs.fs.renderfs.model.properties.PathView;
import io.virtdata.docsys.metafs.fs.renderfs.model.properties.TreeView;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class TargetPathView
implements Versioned,
MarkdownStringer {
    private TargetPathView parent;
    private Path path;
    private long version;
    private static final DirectoryStream.Filter<Path> AcceptAllFiles = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) throws IOException {
            return true;
        }
    };

    public TargetPathView(Path path, long version) {
        this.path = path;
        this.version = version;
    }

    public TargetPathView setParent(TargetPathView parent) {
        this.parent = parent;
        return this;
    }

    public TargetPathView getParent() {
        return this.parent;
    }

    public List<Path> getBreadcrumbs() {
        ArrayList<Path> paths = new ArrayList<Path>();
        this.path.iterator().forEachRemaining(paths::add);
        return paths;
    }

    public PathView getPath() {
        return new PathView(this.path);
    }

    public ListView getFiles() {
        ArrayList files = new ArrayList();
        Path dirPath = this.path.getParent();
        try {
            DirectoryStream<Path> paths = dirPath.getFileSystem().provider().newDirectoryStream(dirPath, AcceptAllFiles);
            paths.forEach(p -> files.add(p.getFileName().toString()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ListView(files);
    }

    public TreeView getFileTree() {
        return new TreeView(this);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public String toString() {
        return "TargetPathView{path=" + this.path + ", version=" + this.version + "}";
    }

    @Override
    public String asMarkdown() {
        return "```\n" + this.toString() + "\n```\n";
    }
}

