/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.core;

import io.virtdata.docsys.core.DocServer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocServerApp {
    private static final Logger logger = LoggerFactory.getLogger(DocServerApp.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("help")) {
            DocServerApp.showHelp(new String[0]);
        }
        if (args.length > 0) {
            String subcmd = args[0].toLowerCase();
            args = Arrays.copyOfRange(args, 1, args.length);
            if (subcmd.equals("topics")) {
                DocServerApp.listTopics();
                return;
            } else if (subcmd.equals("search")) {
                DocServerApp.search(args);
                return;
            } else if (subcmd.equals("help")) {
                DocServerApp.showHelp(args);
                return;
            } else {
                if (!subcmd.equals("server")) throw new RuntimeException("unknown subcommand: " + subcmd);
                DocServerApp.runServer(args);
            }
            return;
        } else {
            DocServerApp.runServer(args);
        }
    }

    private static void runServer(String[] serverArgs) {
        Path contentRoot = Paths.get("docs", new String[0]).toAbsolutePath().normalize();
        Path docsysDocs = Paths.get("virtdata-docsys/docs", new String[0]).toAbsolutePath().normalize();
        logger.info("Starting server with content root:" + contentRoot.toString());
        DocServer server = new DocServer().addPaths(contentRoot, docsysDocs);
        server.run();
    }

    private static void showHelp(String ... helpArgs) {
        System.out.println("Usage:\n topics\n search\n help\n server\n");
    }

    private static void search(String[] searchArgs) {
    }

    private static void listTopics() {
    }
}

