/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.renderers;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.virtdata.docsys.metafs.fs.renderfs.api.MarkdownStringer;
import io.virtdata.docsys.metafs.fs.renderfs.api.Renderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.TemplateCompiler;
import io.virtdata.docsys.metafs.fs.renderfs.model.TargetPathView;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class MustacheProcessor
implements TemplateCompiler {
    public static final Mustache.Compiler compiler = Mustache.compiler().withFormatter((Mustache.Formatter)new Formatter());

    @Override
    public Renderer apply(ByteBuffer byteBuffer) {
        return new MustacheRenderer(byteBuffer);
    }

    public String toString() {
        return MustacheProcessor.class.getSimpleName();
    }

    public static class Formatter
    implements Mustache.Formatter {
        public String format(Object value) {
            if (value instanceof MarkdownStringer) {
                return ((MarkdownStringer)value).asMarkdown();
            }
            return value.toString();
        }
    }

    public static class MustacheRenderer
    implements Renderer {
        private String rawTemplate;
        private Template compiledTemplate;

        public MustacheRenderer(ByteBuffer templateBuffer) {
            this.rawTemplate = new String(templateBuffer.array(), StandardCharsets.UTF_8);
        }

        @Override
        public ByteBuffer apply(TargetPathView targetPathView) {
            try {
                if (this.compiledTemplate == null) {
                    this.compiledTemplate = compiler.compile(this.rawTemplate);
                }
                String renderedText = this.compiledTemplate.execute((Object)targetPathView);
                return ByteBuffer.wrap(renderedText.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder(this.rawTemplate.length() + 4096);
                sb.append(e.getMessage());
                return ByteBuffer.wrap(sb.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

