/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import io.virtdata.docsys.metafs.fs.renderfs.api.CompositeTemplate;
import io.virtdata.docsys.metafs.fs.renderfs.api.FileContentRenderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.Renderable;
import io.virtdata.docsys.metafs.fs.renderfs.api.RenderableChain;
import io.virtdata.docsys.metafs.fs.renderfs.api.RenderableEntry;
import io.virtdata.docsys.metafs.fs.renderfs.api.RendererIO;
import io.virtdata.docsys.metafs.fs.renderfs.api.TemplateCompiler;
import io.virtdata.docsys.metafs.fs.renderfs.model.TargetPathView;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.AccessMode;
import java.nio.file.Path;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileRenderer
implements FileContentRenderer {
    private final String sourceExtension;
    private final String targetExtension;
    private final Pattern sourceNamePattern;
    private final Pattern targetNamePattern;
    private final boolean isCaseSensitive;
    private final ConcurrentHashMap<String, Renderable> renderables = new ConcurrentHashMap();
    private TemplateCompiler[] compilers;

    public FileRenderer(String sourceExtension, String targetExtension, boolean isCaseSensitive, TemplateCompiler ... compilers) {
        this.compilers = compilers;
        if (!sourceExtension.startsWith(".")) {
            throw new InvalidParameterException("You must provide a source extension in '.xyz' form.");
        }
        if (!targetExtension.startsWith(".")) {
            throw new InvalidParameterException("You must provide a target extension in '.xyz' form.");
        }
        this.isCaseSensitive = isCaseSensitive;
        this.sourceExtension = sourceExtension;
        this.sourceNamePattern = this.toNamePattern(sourceExtension);
        this.targetExtension = targetExtension;
        this.targetNamePattern = this.toNamePattern(targetExtension);
    }

    private Pattern toNamePattern(String fileExtension) {
        Pattern.compile(fileExtension);
        if (fileExtension.matches("\\.[a-zA-Z0-9_-]+")) {
            StringBuilder sb = new StringBuilder("(?<basepath>.+)(?<extension>");
            if (this.isCaseSensitive) {
                sb.append(fileExtension.substring(1));
            } else {
                sb.append("(");
                for (int i = 0; i < fileExtension.length(); ++i) {
                    String charString = fileExtension.substring(i, i + 1);
                    if (charString.equals(".")) {
                        sb.append("\\.");
                        continue;
                    }
                    sb.append("[").append(charString.toUpperCase()).append(charString.toLowerCase()).append("]");
                }
                sb.append(")");
            }
            sb.append(")");
            return Pattern.compile(sb.toString());
        }
        throw new RuntimeException("Invalid extension pattern '" + fileExtension + "'. This must be all letters or numbers.");
    }

    @Override
    public Pattern getSourcePattern() {
        return this.sourceNamePattern;
    }

    @Override
    public Pattern getTargetPattern() {
        return this.targetNamePattern;
    }

    public String getSourceExtension() {
        return this.sourceExtension;
    }

    public String getTargetExtension() {
        return this.targetExtension;
    }

    @Override
    public Path getSourcePath(Path targetName) {
        Matcher matcher = this.targetNamePattern.matcher(targetName.toString());
        if (matcher.matches()) {
            String basepath = matcher.group("basepath");
            String extension = matcher.group("extension");
            if (basepath == null || extension == null) {
                throw new RuntimeException("Unable to extract named fields 'basepath' or 'extension' from target name '" + targetName + "' with pattern '" + this.targetNamePattern + "'");
            }
            return targetName.getFileSystem().getPath(basepath + this.sourceExtension, new String[0]);
        }
        return null;
    }

    @Override
    public Path getRenderedTargetName(Path sourceName) {
        Matcher matcher = this.sourceNamePattern.matcher(sourceName.toString());
        if (matcher.matches()) {
            String basepath = matcher.group("basepath");
            String extension = matcher.group("extension");
            if (basepath == null || extension == null) {
                throw new RuntimeException("Unable to extract named fields 'basepath' or 'extension' from source name '" + sourceName + "' with pattern '" + this.sourceNamePattern + "'");
            }
            return sourceName.getFileSystem().getPath(basepath + this.targetExtension, new String[0]);
        }
        throw new RuntimeException("Unable to match source name '" + sourceName + "' with pattern '" + this.sourceNamePattern + "'");
    }

    @Override
    public String getTargetSuffix() {
        return this.targetExtension;
    }

    @Override
    public synchronized ByteBuffer render(Path sourcePath, Path targetPath, ByteBuffer byteBuffer) {
        long lastModified = RendererIO.mtimeFor(sourcePath);
        LinkedList<Path> renderLayers = this.getRenderLayers(sourcePath);
        CompositeTemplate compositeTemplateProvider = new CompositeTemplate(renderLayers);
        Renderable renderable = this.renderables.get(targetPath.toString());
        if (renderable == null) {
            renderable = this.compilers.length == 1 ? new RenderableEntry(() -> RendererIO.readBuffer(sourcePath), this.compilers[0]) : new RenderableChain(() -> RendererIO.readBuffer(sourcePath), this.compilers);
            this.renderables.put(targetPath.toString(), renderable);
        }
        ByteBuffer rendered = (ByteBuffer)renderable.apply(new TargetPathView(targetPath, lastModified));
        return rendered.asReadOnlyBuffer();
    }

    private LinkedList<Path> getRenderLayers(Path sourcePath) {
        sourcePath = sourcePath.normalize();
        LinkedList<Path> renderchain = new LinkedList<Path>();
        renderchain.add(sourcePath);
        for (Path directoryPath = sourcePath.getParent(); directoryPath != null; directoryPath = directoryPath.getParent()) {
            try {
                Path candidate = directoryPath.resolve("_template" + this.sourceExtension);
                candidate.getFileSystem().provider().checkAccess(candidate, AccessMode.READ);
                renderchain.addFirst(candidate);
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
        return renderchain;
    }

    public String toString() {
        return this.sourceExtension + "->" + this.targetExtension + ", with " + Arrays.toString(this.compilers);
    }
}

