/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import io.virtdata.docsys.metafs.fs.renderfs.api.Renderable;
import io.virtdata.docsys.metafs.fs.renderfs.api.RenderableEntry;
import io.virtdata.docsys.metafs.fs.renderfs.api.TemplateCompiler;
import io.virtdata.docsys.metafs.fs.renderfs.model.TargetPathView;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.util.function.Supplier;

public class RenderableChain
implements Renderable {
    private RenderableEntry[] entries;

    public RenderableChain(Supplier<ByteBuffer> initialBufferSource, TemplateCompiler ... compilers) {
        this.entries = new RenderableEntry[compilers.length];
        if (compilers.length == 0) {
            throw new InvalidParameterException("There must be at least 1 compiler for a rendered chain.");
        }
        this.entries[0] = new RenderableEntry(initialBufferSource, compilers[0]);
        if (this.entries.length > 1) {
            for (int i = 1; i < compilers.length; ++i) {
                this.entries[i] = new RenderableEntry(this.entries[i - 1], compilers[i]);
            }
        }
    }

    @Override
    public long getVersion() {
        return this.entries[this.entries.length - 1].getVersion();
    }

    @Override
    public ByteBuffer apply(TargetPathView targetPathView) {
        return this.entries[this.entries.length - 1].apply(targetPathView);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Chain");
        sb.append("[").append(this.entries == null ? "-init-" : Integer.valueOf(this.entries.length)).append("]:");
        for (RenderableEntry entry : this.entries) {
            sb.append(entry == null ? "NULL" : entry.toString());
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

