/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import io.virtdata.docsys.metafs.fs.renderfs.api.Renderable;
import io.virtdata.docsys.metafs.fs.renderfs.api.Renderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.TemplateCompiler;
import io.virtdata.docsys.metafs.fs.renderfs.model.TargetPathView;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

public class RenderableEntry
implements Renderable {
    private final Supplier<ByteBuffer> bufferSource;
    private final RenderableEntry upstream;
    private long renderedVersion;
    private ByteBuffer input;
    private TemplateCompiler compiler;
    private Renderer renderer;
    private ByteBuffer output;

    public RenderableEntry(Supplier<ByteBuffer> bufferSource, TemplateCompiler compiler) {
        this.compiler = compiler;
        this.bufferSource = bufferSource;
        this.upstream = null;
    }

    public RenderableEntry(RenderableEntry upstream, TemplateCompiler compiler) {
        this.upstream = upstream;
        this.compiler = compiler;
        this.bufferSource = null;
    }

    @Override
    public long getVersion() {
        return this.renderedVersion;
    }

    @Override
    public ByteBuffer apply(TargetPathView targetPathView) {
        if (this.output != null && this.isValidFor(targetPathView)) {
            return this.output;
        }
        this.input = this.bufferSource != null ? this.bufferSource.get() : this.upstream.apply(targetPathView);
        this.renderer = (Renderer)this.compiler.apply(this.input);
        this.output = (ByteBuffer)this.renderer.apply(targetPathView);
        this.renderedVersion = targetPathView.getVersion();
        return this.output;
    }

    public String toString() {
        return this.compiler.getClass().getSimpleName() + ":input=" + (Serializable)(this.input == null ? "NULL" : Integer.valueOf(this.input.capacity())) + " output=" + (Serializable)(this.output == null ? "NULL" : Integer.valueOf(this.output.capacity()));
    }
}

