/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;

public interface FileContentRenderer {
    public Pattern getSourcePattern();

    public Pattern getTargetPattern();

    default public boolean matchesSource(Path p) {
        return this.getSourcePattern().matcher(p.toString()).matches();
    }

    default public boolean matchesTarget(Path p) {
        return this.getTargetPattern().matcher(p.toString()).matches();
    }

    default public boolean hasSource(Path p) {
        Path sourcePath = this.getSourcePath(p);
        try {
            sourcePath.getFileSystem().provider().checkAccess(sourcePath, AccessMode.READ);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    default public boolean canRender(Path p) {
        return this.matchesTarget(p) && this.hasSource(p);
    }

    public String getTargetSuffix();

    public Path getSourcePath(Path var1);

    public Path getRenderedTargetName(Path var1);

    default public InputStream getInputStream(Path targetName) {
        ByteBuffer buf = this.getRendered(targetName);
        if (buf == null) {
            return null;
        }
        return new ByteArrayInputStream(buf.array());
    }

    public ByteBuffer render(Path var1, Path var2, ByteBuffer var3);

    default public ByteBuffer getRendered(Path targetPath) {
        Path sourcePath = this.getSourcePath(targetPath);
        if (sourcePath != null) {
            try {
                ByteBuffer rawInput = this.getByteBuffer(sourcePath);
                ByteBuffer rendered = this.render(sourcePath, targetPath, rawInput);
                return rendered;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            catch (Exception e) {
                throw e;
            }
        }
        return null;
    }

    default public SeekableByteChannel getByteChannel(Path targetPath) {
        Path sourcePath = this.getSourcePath(targetPath);
        if (sourcePath != null) {
            try {
                ByteBuffer rawInput = this.getByteBuffer(sourcePath);
                ByteBuffer renderedOutput = this.render(sourcePath, targetPath, rawInput);
                SeekableInMemoryByteChannel channel = new SeekableInMemoryByteChannel();
                channel.write(renderedOutput);
                channel.position(0L);
                return channel;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    default public ByteBuffer getByteBuffer(Path sourcePath) throws IOException {
        InputStream inputStream = sourcePath.getFileSystem().provider().newInputStream(sourcePath, new OpenOption[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        inputStream.transferTo(bos);
        return ByteBuffer.wrap(bos.toByteArray());
    }
}

