/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.fs;

import io.virtdata.docsys.metafs.core.MetaPath;
import io.virtdata.docsys.metafs.fs.renderfs.api.FileContentRenderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.Renderers;
import io.virtdata.docsys.metafs.fs.renderfs.fs.RenderFSDirectoryStream;
import io.virtdata.docsys.metafs.fs.renderfs.fs.RenderFSProvider;
import io.virtdata.docsys.metafs.fs.renderfs.fs.RenderedBasicFileAttributes;
import io.virtdata.docsys.metafs.fs.renderfs.fs.RenderedFileAttributeMap;
import io.virtdata.docsys.metafs.fs.renderfs.fs.RenderedFileAttributeView;
import io.virtdata.docsys.metafs.fs.virtual.VirtFS;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.Set;

public class RenderFS
extends VirtFS {
    private final RenderFSProvider provider = RenderFSProvider.get();
    Renderers renderers = new Renderers();

    public RenderFS(FileSystem layer) {
        super(layer.getPath(layer.getSeparator(), new String[0]));
    }

    public RenderFS(Path wrapped) {
        super(wrapped);
    }

    public RenderFS(URI baseUri) {
        this(Path.of(baseUri));
    }

    public Renderers getRenderers() {
        return this.renderers;
    }

    public void addRenderer(FileContentRenderer rendererType) {
        this.renderers.add(rendererType);
    }

    @Override
    public RenderFSProvider provider() {
        return this.provider;
    }

    public DirectoryStream<Path> newDirectoryStream(DirectoryStream<Path> paths) {
        return new RenderFSDirectoryStream(paths, this.renderers);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        MetaPath metaPath = this.assertMetaPath(path);
        Path syspath = (Path)this.metaToSysFunc.apply(metaPath);
        try {
            SeekableByteChannel channel = super.newByteChannel(path, options, attrs);
            return channel;
        }
        catch (Exception e) {
            FileContentRenderer renderer = this.renderers.forTargetPath(path);
            if (renderer != null) {
                return renderer.getByteChannel(path);
            }
            return syspath.getFileSystem().provider().newByteChannel(syspath, options, attrs);
        }
    }

    public BasicFileAttributes readAttributes(Path path, Class type, LinkOption ... options) throws IOException {
        try {
            return super.readAttributes(path, type, options);
        }
        catch (Exception e1) {
            FileContentRenderer renderer = this.renderers.forTargetPath(path);
            if (renderer != null) {
                try {
                    Path sourcePath = renderer.getSourcePath(path);
                    ByteBuffer rendered = renderer.getRendered(path);
                    BasicFileAttributes attrs = this.readAttributes(sourcePath, type, options);
                    return new RenderedBasicFileAttributes(attrs, rendered.remaining());
                }
                catch (Exception e) {
                    throw new RuntimeException("There was a problem rendering " + path.toString() + " with " + renderer);
                }
            }
            throw e1;
        }
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption[] options) throws IOException {
        try {
            return super.readAttributes(path, attributes, options);
        }
        catch (Exception e1) {
            FileContentRenderer renderer = this.renderers.forTargetPath(path);
            if (renderer != null) {
                Path sourcePath = renderer.getSourcePath(path);
                ByteBuffer rendered = renderer.getRendered(path);
                Map<String, Object> sourceAttrs = this.readAttributes(sourcePath, attributes, options);
                return new RenderedFileAttributeMap(sourcePath, sourceAttrs, path, rendered.remaining());
            }
            throw e1;
        }
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        block2: {
            try {
                super.checkAccess(path, modes);
            }
            catch (Exception e1) {
                FileContentRenderer renderer = this.renderers.forTargetPath(path);
                if (renderer != null) break block2;
                throw e1;
            }
        }
    }

    @Override
    public FileAttributeView getFileAttributeView(Path path, Class type, LinkOption[] options) {
        try {
            super.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return super.getFileAttributeView(path, type, options);
        }
        catch (IOException e1) {
            FileContentRenderer renderer = this.renderers.forTargetPath(path);
            if (renderer != null) {
                Path sourcePath = renderer.getSourcePath(path);
                ByteBuffer rendered = renderer.getRendered(path);
                FileAttributeView sourceFileAttributeView = this.getFileAttributeView(sourcePath, type, options);
                return new RenderedFileAttributeView(sourcePath, sourceFileAttributeView, path, type, options, rendered.remaining());
            }
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return "RenderFS: root=" + super.getOuterMount().toString() + " renderers=" + this.renderers;
    }

    private VirtFS assertThisFs(MetaPath metaPath) {
        if (metaPath.getFileSystem() != this) {
            throw new InvalidParameterException("This path is not a member of this filesystem.");
        }
        return (RenderFS)metaPath.getFileSystem();
    }

    private MetaPath assertMetaPath(Path path) {
        if (!(path instanceof MetaPath)) {
            throw new InvalidParameterException("This path must be an instance of MetaPath to work with " + this);
        }
        return (MetaPath)path;
    }
}

