/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.virtual;

import io.virtdata.docsys.metafs.core.MetaFSProvider;
import io.virtdata.docsys.metafs.core.MetaPath;
import io.virtdata.docsys.metafs.fs.virtual.VirtFS;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.security.InvalidParameterException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtFSProvider
extends MetaFSProvider {
    protected static final Logger logger = LoggerFactory.getLogger(VirtFSProvider.class);
    private static VirtFSProvider instance;
    protected Map<URI, VirtFS> filesystems = new LinkedHashMap<URI, VirtFS>();

    protected VirtFSProvider() {
    }

    public static synchronized VirtFSProvider get() {
        if (instance == null) {
            instance = new VirtFSProvider();
        }
        return instance;
    }

    @Override
    public String getScheme() {
        return "meta";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        if (this.filesystems.containsKey(uri)) {
            throw new FileSystemAlreadyExistsException("meta FileSystem under URI " + uri + " already exists.");
        }
        VirtFS virtFS = new VirtFS(Path.of(uri));
        this.filesystems.put(uri, virtFS);
        return virtFS;
    }

    @Override
    public synchronized FileSystem getFileSystem(URI uri) {
        VirtFS virtFS = this.filesystems.get(uri);
        if (virtFS == null) {
            throw new FileSystemNotFoundException("A meta FileSystem was not found for URI " + uri);
        }
        return virtFS;
    }

    @Override
    public Path getPath(URI uri) {
        if (!uri.getScheme().equals(this.getScheme())) {
            throw new IllegalArgumentException("Invalid uri scheme '" + uri.getScheme() + "' for " + this.getClass().getCanonicalName() + ".getPath(URI)");
        }
        for (Map.Entry<URI, VirtFS> entry : this.filesystems.entrySet()) {
            if (!entry.getKey().toString().startsWith(uri.toString())) continue;
            URI relativeUri = entry.getKey().relativize(uri);
            return Path.of(relativeUri);
        }
        throw new FileSystemNotFoundException("A file system for provider-scoped URI '" + uri + "' was not found.");
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        MetaPath metaPath = this.assertMetaPath(path);
        return metaPath.getFileSystem().newByteChannel(path, options, attrs);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
    }

    @Override
    public void delete(Path path) throws IOException {
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return false;
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return null;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        Path sysPath = this.getContainerPath(path);
        sysPath.getFileSystem().provider().checkAccess(sysPath, modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        Path sysPath = this.getContainerPath(path);
        V fileAttributeView = sysPath.getFileSystem().provider().getFileAttributeView(sysPath, type, options);
        return fileAttributeView;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Path syspath = this.getContainerPath(path);
        A attributes = syspath.getFileSystem().provider().readAttributes(syspath, type, options);
        return attributes;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        Path syspath = this.getContainerPath(path);
        Map<String, Object> stringObjectMap = syspath.getFileSystem().provider().readAttributes(syspath, attributes, options);
        return stringObjectMap;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        Path syspath = this.getContainerPath(path);
        syspath.getFileSystem().provider().setAttribute(syspath, attribute, value, options);
    }

    protected Path getContainerPath(Path path) {
        MetaPath metapath = this.assertMetaPath(path);
        VirtFS virtfs = this.assertVirtFS(metapath);
        return virtfs.metaToSysFunc.apply(metapath);
    }

    private VirtFS assertVirtFS(MetaPath metaPath) {
        if (!(metaPath.getFileSystem() instanceof VirtFS)) {
            throw new InvalidParameterException("This path is not a member of a VirtFS filesystem.");
        }
        return (VirtFS)metaPath.getFileSystem();
    }

    private MetaPath assertMetaPath(Path path) {
        if (!(path instanceof MetaPath)) {
            throw new InvalidParameterException("This path must be an instance of MetaPath to work with " + this);
        }
        return (MetaPath)path;
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        MetaPath metapath = this.assertMetaPath(dir);
        VirtFS virtFS = this.assertVirtFS(metapath);
        return virtFS.newDirectoryStream(metapath, filter);
    }
}

