/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.AccessMode;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface FileContentRenderer {
    public Pattern getSourcePattern();

    public Pattern getTargetPattern();

    default public boolean matchesSource(Path p) {
        return this.getSourcePattern().matcher(p.toString()).matches();
    }

    default public boolean matchesTarget(Path p) {
        Pattern targetPattern = this.getTargetPattern();
        Matcher matcher = targetPattern.matcher(p.toString());
        return matcher.matches();
    }

    default public boolean hasSource(Path p) {
        Path sourcePath = this.getSourcePath(p);
        try {
            sourcePath.getFileSystem().provider().checkAccess(sourcePath, AccessMode.READ);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    default public boolean canRender(Path p) {
        return this.matchesTarget(p) && this.hasSource(p);
    }

    public Path getSourcePath(Path var1);

    public Path getRenderedTargetName(Path var1);

    private InputStream getInputStream(Path targetName) {
        ByteBuffer buf = this.getRendered(targetName);
        if (buf == null) {
            return null;
        }
        return new ByteArrayInputStream(buf.array());
    }

    public ByteBuffer render(Path var1, Path var2, ByteBuffer var3);

    private ByteBuffer getRendered(Path targetPath) {
        Path sourcePath = this.getSourcePath(targetPath);
        if (sourcePath != null) {
            try {
                ByteBuffer rawInput = this.getRawByteBuffer(sourcePath);
                ByteBuffer rendered = this.render(sourcePath, targetPath, rawInput);
                return rendered;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            catch (Exception e) {
                throw e;
            }
        }
        return null;
    }

    private ByteBuffer getRawByteBuffer(Path sourcePath) throws IOException {
        InputStream inputStream = sourcePath.getFileSystem().provider().newInputStream(sourcePath, new OpenOption[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        inputStream.transferTo(bos);
        return ByteBuffer.wrap(bos.toByteArray()).asReadOnlyBuffer();
    }

    default public VirtualFile getVirtualFile(Path target) {
        ByteBuffer bb = this.getRendered(target);
        if (bb == null) {
            return null;
        }
        Path delegate = this.getSourcePath(target);
        return new VirtualFile(delegate, target, bb);
    }
}

