/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api.rendering;

import io.virtdata.docsys.metafs.fs.renderfs.api.SourcePathTemplate;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.ExceptionContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.RenderedContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.IRenderingScope;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.Renderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateCompiler;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateView;
import io.virtdata.docsys.metafs.fs.renderfs.model.ViewModel;
import java.nio.file.Path;

public class RenderingScope
implements IRenderingScope {
    private final TemplateView templateView;
    private final ViewModel viewModel;
    private final TemplateCompiler compiler;
    private RenderingScope innerScope;
    private Renderer renderer;
    private RenderedContent rendered;

    public RenderingScope(TemplateView templateView, ViewModel viewModel, TemplateCompiler compiler) {
        this.templateView = templateView;
        this.viewModel = viewModel;
        this.compiler = compiler;
    }

    public RenderingScope(Path sourcePath, Path targetPath, TemplateCompiler compiler) {
        this(new SourcePathTemplate(sourcePath), new ViewModel(sourcePath, targetPath), compiler);
    }

    @Override
    public long getVersion() {
        return Math.max(this.templateView.getVersion(), this.viewModel.getVersion());
    }

    @Override
    public String getTemplateView() {
        return (String)this.templateView.get();
    }

    @Override
    public ViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public RenderedContent getRendered() {
        try {
            if (this.innerScope != null) {
                this.innerScope.getRendered();
                this.getViewModel().setInner(this.innerScope.getViewModel());
            }
            if (this.rendered == null || !this.rendered.isValidFor(this)) {
                if (this.renderer == null || !this.renderer.isValidFor(this)) {
                    this.renderer = (Renderer)this.compiler.apply(this.templateView);
                }
                this.rendered = (RenderedContent)this.renderer.apply(this);
            }
            return this.rendered;
        }
        catch (Exception e) {
            return new ExceptionContent(e, this.templateView.getVersion());
        }
    }

    public RenderingScope wrap(RenderingScope innerScope) {
        this.innerScope = innerScope;
        this.viewModel.setInner(innerScope.getViewModel());
        return this;
    }

    public String toString() {
        return "[view: " + this.getViewModel().getPath().toString() + "][target: " + this.getViewModel().getTarget() + "]";
    }
}

