/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.renderers;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.ExceptionContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.RenderedContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.StringContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.Renderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.RenderingScope;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateCompiler;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateView;

public class MarkdownProcessor
implements TemplateCompiler {
    @Override
    public Renderer apply(TemplateView templateView) {
        return new MarkdownRenderer((String)templateView.get());
    }

    public String toString() {
        return "\ud83c\udd6b";
    }

    public static class MarkdownRenderer
    implements Renderer {
        protected static final Parser parser = Parser.builder().build();
        protected static final HtmlRenderer renderer = HtmlRenderer.builder().build();
        private final Document document;
        private long version;

        public MarkdownRenderer(String template) {
            this.document = parser.parse(template);
        }

        @Override
        public RenderedContent apply(RenderingScope targetPathView) {
            try {
                String rendered = renderer.render((Node)this.document);
                this.version = targetPathView.getVersion();
                return new StringContent(rendered, targetPathView.getVersion());
            }
            catch (Exception e) {
                return new ExceptionContent(e, targetPathView.getVersion());
            }
        }

        @Override
        public long getVersion() {
            return this.version;
        }
    }
}

