/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.api;

import io.virtdata.docsys.metafs.fs.renderfs.api.FileContentRenderer;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendered.RenderedContent;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.RenderingScope;
import io.virtdata.docsys.metafs.fs.renderfs.api.rendering.TemplateCompiler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessMode;
import java.nio.file.Path;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileRenderer
implements FileContentRenderer {
    private final String sourceExtension;
    private final String targetExtension;
    private final Pattern sourceNamePattern;
    private final Pattern targetNamePattern;
    private final boolean isCaseSensitive;
    private TemplateCompiler compiler;

    public FileRenderer(String fromext, String toext, boolean cased, TemplateCompiler compiler) {
        this.compiler = compiler;
        if (!fromext.startsWith(".")) {
            throw new InvalidParameterException("You must provide a source extension in '.xyz' form.");
        }
        if (!toext.startsWith(".")) {
            throw new InvalidParameterException("You must provide a target extension in '.xyz' form.");
        }
        this.isCaseSensitive = cased;
        this.sourceExtension = fromext;
        this.sourceNamePattern = this.toNamePattern(fromext);
        this.targetExtension = toext;
        this.targetNamePattern = this.toNamePattern(toext);
    }

    private Pattern toNamePattern(String fileExtension) {
        Pattern.compile(fileExtension);
        StringBuilder sb = new StringBuilder("(?<basepath>.+)(?<extension>");
        if (this.isCaseSensitive) {
            sb.append(Pattern.quote(fileExtension));
        } else {
            for (int i = 0; i < fileExtension.length(); ++i) {
                String c = fileExtension.substring(i, i + 1);
                if (c.toUpperCase().equals(c.toLowerCase())) {
                    sb.append(Pattern.quote(c));
                    continue;
                }
                sb.append("[").append(c.toLowerCase()).append(c.toUpperCase()).append("]");
            }
            sb.append(")");
        }
        String pattern = sb.toString().replaceAll("\\\\E\\\\Q", "");
        return Pattern.compile(pattern);
    }

    @Override
    public List<Path> getVirtualPathsFor(Path path) {
        ArrayList<Path> vpaths = new ArrayList<Path>();
        if (this.matchesSource(path) && !this.isTemplatePath(path)) {
            Path targetPaths = this.getRenderedTargetName(path);
            vpaths.add(targetPaths);
        }
        return vpaths;
    }

    @Override
    public Pattern getSourcePattern() {
        return this.sourceNamePattern;
    }

    @Override
    public Pattern getTargetPattern() {
        return this.targetNamePattern;
    }

    @Override
    public boolean isTemplatePath(Path p) {
        String filename = p.getName(p.getNameCount() - 1).toString();
        return filename.startsWith("__.") || filename.contains("._") || filename.startsWith("_.");
    }

    public String getSourceExtension() {
        return this.sourceExtension;
    }

    public String getTargetExtension() {
        return this.targetExtension;
    }

    @Override
    public Path getSourcePath(Path targetName) {
        Matcher matcher = this.targetNamePattern.matcher(targetName.toString());
        if (matcher.matches()) {
            String basepath = matcher.group("basepath");
            String extension = matcher.group("extension");
            if (basepath == null || extension == null) {
                throw new RuntimeException("Unable to extract named fields 'basepath' or 'extension' from target name '" + targetName + "' with pattern '" + this.targetNamePattern + "'");
            }
            return targetName.getFileSystem().getPath(basepath + this.sourceExtension, new String[0]);
        }
        return null;
    }

    @Override
    public Path getRenderedTargetName(Path sourceName) {
        Matcher matcher = this.sourceNamePattern.matcher(sourceName.toString());
        if (matcher.matches()) {
            String basepath = matcher.group("basepath");
            String extension = matcher.group("extension");
            if (basepath == null || extension == null) {
                throw new RuntimeException("Unable to extract named fields 'basepath' or 'extension' from source name '" + sourceName + "' with pattern '" + this.sourceNamePattern + "'");
            }
            return sourceName.getFileSystem().getPath(basepath + this.targetExtension, new String[0]);
        }
        throw new RuntimeException("Unable to match source name '" + sourceName + "' with pattern '" + this.sourceNamePattern + "'");
    }

    @Override
    public synchronized ByteBuffer render(Path sourcePath, Path targetPath, ByteBuffer byteBuffer) {
        RenderingScope scope = new RenderingScope(sourcePath, targetPath, this.compiler);
        for (Path template : this.getTemplates(sourcePath)) {
            RenderingScope outer = new RenderingScope(template, template, this.compiler);
            scope = outer.wrap(scope);
        }
        RenderedContent rendered = scope.getRendered();
        byte[] bytes = ((String)rendered.get()).getBytes(StandardCharsets.UTF_8);
        return ByteBuffer.wrap(bytes).asReadOnlyBuffer();
    }

    private LinkedList<Path> getTemplates(Path sourcePath) {
        Path localTmpl2;
        LinkedList<Path> chain = new LinkedList<Path>();
        sourcePath.normalize();
        Path directoryPath = sourcePath.getParent();
        String[] parts = sourcePath.toString().split("\\.");
        String extension = parts[parts.length - 1];
        try {
            localTmpl2 = directoryPath.resolve("_." + extension);
            localTmpl2.getFileSystem().provider().checkAccess(localTmpl2, AccessMode.READ);
            chain.addFirst(localTmpl2);
        }
        catch (IOException localTmpl2) {
            // empty catch block
        }
        while (directoryPath != null) {
            try {
                localTmpl2 = directoryPath.resolve("__." + extension);
                localTmpl2.getFileSystem().provider().checkAccess(localTmpl2, AccessMode.READ);
                chain.addFirst(localTmpl2);
                directoryPath = directoryPath.getParent();
            }
            catch (IOException ignored) {
                break;
            }
        }
        return chain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.compiler.toString()).append(this.sourceExtension).append("\u2192").append(this.targetExtension).append(")");
        return sb.toString();
    }
}

