/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio;

import io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio.RenderedFileAttributeView;
import io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio.VirtualFileAttributeMap;
import io.virtdata.docsys.metafs.fs.renderfs.fs.virtualio.VirtualFileBasicFileAttributes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;

public class VirtualFile {
    private ByteBuffer contentCache;
    private final Path target;
    private final Path delegate;
    private final Supplier<ByteBuffer> dynamicRenderer;

    public VirtualFile(Path delegate, Path target, Supplier<ByteBuffer> dynamicRenderer) {
        this.delegate = delegate;
        this.target = target;
        this.dynamicRenderer = dynamicRenderer;
    }

    private ByteBuffer getContent() {
        if (this.contentCache == null) {
            this.contentCache = this.dynamicRenderer.get().asReadOnlyBuffer();
        }
        return this.contentCache;
    }

    public BasicFileAttributes readAttributes(Path path, Class<? extends BasicFileAttributes> type, LinkOption ... options) throws IOException {
        FileSystemProvider provider = this.delegate.getFileSystem().provider();
        BasicFileAttributes delegateAttrs = provider.readAttributes(this.delegate, type, options);
        return new VirtualFileBasicFileAttributes(delegateAttrs, this.getContent().remaining());
    }

    public SeekableByteChannel getSeekableByteChannel() {
        try {
            SeekableInMemoryByteChannel channel = new SeekableInMemoryByteChannel();
            channel.write(this.getContent().asReadOnlyBuffer());
            channel.position(0L);
            return channel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption[] options) throws IOException {
        FileSystemProvider provider = this.delegate.getFileSystem().provider();
        Map<String, Object> sourceAttrs = provider.readAttributes(this.delegate, attributes, options);
        return new VirtualFileAttributeMap(this.delegate, sourceAttrs, path, this.getContent().remaining());
    }

    public void checkAccess(Path path, AccessMode[] modes) throws IOException {
        for (AccessMode mode : modes) {
            if (mode == AccessMode.WRITE) {
                throw new AccessDeniedException(path.toString());
            }
            if (mode != AccessMode.EXECUTE) continue;
            throw new AccessDeniedException(path.toString());
        }
    }

    public FileAttributeView getFileAttributeView(Path path, Class type, LinkOption[] options) {
        FileSystemProvider provider = this.delegate.getFileSystem().provider();
        Object sourceFileAttributeView = provider.getFileAttributeView(this.delegate, type, options);
        return new RenderedFileAttributeView(this.delegate, (FileAttributeView)sourceFileAttributeView, path, type, options, this.getContent().remaining());
    }
}

